/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import java.util.logging.Level;

public class SecurityServiceTest
extends GenericValidator {
    static boolean checked = false;

    public SecurityServiceTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        if (cce.getChoice().equals("ADD") || cce.getChoice().equals("OFFLINE")) {
            try {
                ConfigContext context = cce.getConfigContext();
                SecurityService sec = (SecurityService)cce.getValidationTarget();
                boolean isRealm = false;
                String name = sec.getDefaultRealm();
                AuthRealm[] authRealm = sec.getAuthRealm();
                if (authRealm.length == 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".authRealmMinOne", "Auth Realm Element required - one or more "));
                }
                for (int i = 0; i < authRealm.length; ++i) {
                    if (!authRealm[i].getName().equals(name)) continue;
                    isRealm = true;
                }
                if (!isRealm) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".authRealmNotAvl", "Attribute(auth-realm={0}) : {0} Auth Realm Not Available", new Object[]{name}));
                }
                boolean isJacc = false;
                String jacc = sec.getJacc();
                JaccProvider[] jaccprovider = sec.getJaccProvider();
                if (jaccprovider.length == 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".jaccproviderMinOne", "Jacc Provider Element required - one or more "));
                }
                for (int i = 0; i < jaccprovider.length; ++i) {
                    if (!jaccprovider[i].getName().equals(jacc)) continue;
                    isJacc = true;
                }
                if (!isJacc) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".jaacProvNotAvl", "Attribute(jaac-prov={0}) : {0} Jacc Provider Not Available", new Object[]{jacc}));
                }
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "domainxmlverifier.exception", e);
            }
        }
        return result;
    }
}

