/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.Profiler;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.tests.JvmOptionsTest;
import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;

public class ProfilerTest
extends GenericValidator {
    public ProfilerTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        String name;
        Result result = super.validate(cce);
        if (cce.getChoice().equals("OFFLINE")) {
            Profiler profiler = (Profiler)cce.getObject();
            this.validateAttribute(ServerTags.CLASSPATH, profiler.getClasspath(), result);
            JvmOptionsTest.validateJvmOptions(profiler.getJvmOptions(), result);
        }
        if (cce.getChoice().equals("UPDATE")) {
            this.validateAttribute(cce.getName(), (String)cce.getObject(), result);
        } else if (cce.getChoice().equals("SET") && (name = cce.getName()).equals("JvmOptions")) {
            JvmOptionsTest.validateJvmOptions((String[])cce.getObject(), result);
        }
        return result;
    }

    public void validateAttribute(String name, String value, Result result) {
        if (value == null || value.equals("")) {
            return;
        }
        if (name.equals(ServerTags.CLASSPATH) && !StaticTest.isClassPathValid(value)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidProfilerClasspath", "Attribute:(classpath={0}), Invalid path in classpath", new Object[]{value}));
        }
    }
}

