/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.admin.util.QuotedStringTokenizer;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.StringManagerHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class JvmOptionsTest {
    private static LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    private static final JvmOptionsTest instance = new JvmOptionsTest();

    private JvmOptionsTest() {
    }

    public static void validateJvmOptions(String[] jvmOptions, Result result) {
        try {
            instance.checkForNullOptions(jvmOptions);
            Set optionsSet = instance.tokenizeJvmOptions(jvmOptions);
            instance.checkBeginWithDash(optionsSet);
            instance.checkQuotes(optionsSet);
        }
        catch (Exception e) {
            result.failed(e.getMessage());
        }
    }

    private void checkForNullOptions(String[] options) throws InvalidJvmOptionsException {
        if (null == options) {
            throw new InvalidJvmOptionsException(this.getNullJvmOptionMsg());
        }
        for (int i = 0; i < options.length; ++i) {
            if (null != options[i]) continue;
            throw new InvalidJvmOptionsException(this.getNullJvmOptionMsg());
        }
    }

    private void checkBeginWithDash(Set options) throws InvalidJvmOptionsException {
        ArrayList<String> invalidOptions = new ArrayList<String>();
        Iterator it = options.iterator();
        while (it.hasNext()) {
            String option = it.next().toString();
            if (option.startsWith("-")) continue;
            invalidOptions.add(option);
        }
        if (invalidOptions.size() > 0) {
            throw new InvalidJvmOptionsException(this.getInvalidJvmOptionMsg(((Object)invalidOptions).toString()));
        }
    }

    private void checkQuotes(Set options) throws InvalidJvmOptionsException {
        ArrayList<String> invalidOptions = new ArrayList<String>();
        Iterator it = options.iterator();
        while (it.hasNext()) {
            String option = it.next().toString();
            if (this.checkQuotes(option)) continue;
            invalidOptions.add(option);
        }
        if (invalidOptions.size() > 0) {
            throw new InvalidJvmOptionsException(this.getIncorrectQuotesMsg(((Object)invalidOptions).toString()));
        }
    }

    private boolean checkQuotes(String option) {
        int length = option.length();
        int numQuotes = 0;
        for (int index = 0; index < length && (index = option.indexOf(34, index)) != -1; ++index) {
            ++numQuotes;
        }
        return numQuotes % 2 == 0;
    }

    private Set tokenizeJvmOptions(String[] options) {
        LinkedHashSet<String> optionsSet = new LinkedHashSet<String>();
        String DELIM = " \t";
        for (int i = 0; i < options.length; ++i) {
            QuotedStringTokenizer strTok = new QuotedStringTokenizer(options[i], " \t");
            while (strTok.hasMoreTokens()) {
                optionsSet.add(strTok.nextToken());
            }
        }
        return Collections.unmodifiableSet(optionsSet);
    }

    private String getNullJvmOptionMsg() {
        return smh.getLocalString(this.getClass().getName() + ".nullJvmOption", "Null Jvm option", new Object[0]);
    }

    private String getInvalidJvmOptionMsg(String invalidOptions) {
        return smh.getLocalString(this.getClass().getName() + ".invalidJvmOption", "{0} - Invalid Jvm option. Option must begin with -", new Object[]{invalidOptions});
    }

    private String getIncorrectQuotesMsg(String invalidOptions) {
        return smh.getLocalString(this.getClass().getName() + ".incorrectQuotesInJvmOption", "{0} - Invalid Jvm option. Check quotes", new Object[]{invalidOptions});
    }

    private static final class InvalidJvmOptionsException
    extends Exception {
        InvalidJvmOptionsException(String msg) {
            super(msg);
        }
    }
}

