/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.PersistenceManagerFactoryResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.tests.ResourceTest;
import java.util.Set;
import java.util.logging.Level;

public class JdbcResourceTest
extends ResourceTest {
    static boolean checked = false;

    public JdbcResourceTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        if (cce.getChoice().equals("UPDATE")) {
            try {
                if (cce.getName().equals(ServerTags.POOL_NAME)) {
                    String jndi = ((JdbcResource)cce.getClassObject()).getJndiName();
                    ConfigContext context = cce.getConfigContext();
                    Domain domain = (Domain)context.getRootConfigBean();
                    Resources resource = domain.getResources();
                    boolean flag = false;
                    PersistenceManagerFactoryResource[] persRes = resource.getPersistenceManagerFactoryResource();
                    for (int i = 0; i < persRes.length; ++i) {
                        if (!jndi.equals(persRes[i].getJdbcResourceJndiName())) continue;
                        flag = true;
                        break;
                    }
                    if (flag) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".jndiNameNotEditable", "{0}, Jndi Resource used by Persistence Manager Factory Resource, pool name not Editable", new Object[]{jndi}));
                    }
                }
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "domainxmlverifier.exception", e);
            }
        }
        if (cce.getChoice().equals("ADD") || cce.getChoice().equals("OFFLINE")) {
            try {
                ConfigContext context = cce.getConfigContext();
                Object value = cce.getObject();
                JdbcResource jdbc = (JdbcResource)value;
                boolean isPool = false;
                String pool = jdbc.getPoolName();
                Domain domain = (Domain)context.getRootConfigBean();
                Resources resource = domain.getResources();
                JdbcConnectionPool[] connection = resource.getJdbcConnectionPool();
                for (int i = 0; i < connection.length; ++i) {
                    if (!connection[i].getName().equals(pool)) continue;
                    isPool = true;
                }
                if (!isPool) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".connPoolNotAvl", "{0}, Connection Pool Not Available", new Object[]{pool}));
                }
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "domainxmlverifier.exception", e);
            }
        }
        return result;
    }

    protected final String getName(ConfigContextEvent cce) throws ConfigException {
        return this.getJdbcResource(cce).getJndiName();
    }

    protected final boolean isReferenced(ConfigContextEvent cce) throws ConfigException {
        return ServerBeansFactory.isReferenced((JdbcResource)this.getJdbcResource(cce), (ConfigContext)cce.getConfigContext());
    }

    protected final Set getReferers(ConfigContextEvent cce) throws ConfigException {
        return ServerBeansFactory.getReferers((JdbcResource)this.getJdbcResource(cce), (ConfigContext)cce.getConfigContext());
    }

    private final JdbcResource getJdbcResource(ConfigContextEvent cce) throws ConfigException {
        return (JdbcResource)cce.getValidationTarget();
    }
}

