/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.validation.AttrClassName;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.tests.JvmOptionsTest;
import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;
import java.util.Vector;

public class JavaConfigTest
extends GenericValidator {
    public JavaConfigTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        String name;
        Result result = super.validate(cce);
        if (cce.getChoice().equals("OFFLINE")) {
            StaticTest.setJavaHomeCheck(true);
            JavaConfig javaConfig = (JavaConfig)cce.getObject();
            this.validateAttribute(ServerTags.JAVA_HOME, javaConfig.getJavaHome(), result);
            this.validateAttribute(ServerTags.DEBUG_OPTIONS, javaConfig.getDebugOptions(), result);
            this.validateAttribute(ServerTags.RMIC_OPTIONS, javaConfig.getRmicOptions(), result);
            this.validateAttribute(ServerTags.JAVAC_OPTIONS, javaConfig.getJavacOptions(), result);
            this.validateAttribute(ServerTags.CLASSPATH_PREFIX, javaConfig.getClasspathPrefix(), result);
            this.validateAttribute(ServerTags.CLASSPATH_SUFFIX, javaConfig.getClasspathSuffix(), result);
            this.validateAttribute(ServerTags.NATIVE_LIBRARY_PATH_PREFIX, javaConfig.getNativeLibraryPathPrefix(), result);
            this.validateAttribute(ServerTags.NATIVE_LIBRARY_PATH_SUFFIX, javaConfig.getNativeLibraryPathSuffix(), result);
            this.validateAttribute(ServerTags.BYTECODE_PREPROCESSORS, javaConfig.getBytecodePreprocessors(), result);
            JvmOptionsTest.validateJvmOptions(javaConfig.getJvmOptions(), result);
        }
        if (cce.getChoice().equals("UPDATE")) {
            this.validateAttribute(cce.getName(), (String)cce.getObject(), result);
        } else if (cce.getChoice().equals("SET") && (name = cce.getName()).equals("JvmOptions")) {
            JvmOptionsTest.validateJvmOptions((String[])cce.getObject(), result);
        }
        return result;
    }

    public void validateAttribute(String name, String value, Result result) {
        if (value == null || value.equals("")) {
            return;
        }
        if (name.equals(ServerTags.DEBUG_OPTIONS)) {
            if (!StaticTest.isOptionsValid(value)) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidDebugOption", "{0} : Invalid Java Debug options should start with -", new Object[]{value}));
            }
            this.validateRunJDWP(value, result);
        }
        if (name.equals(ServerTags.RMIC_OPTIONS) && !StaticTest.isOptionsValid(value)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidRmicOption", "{0} : Invalid RMIC options should start with -", new Object[]{value}));
        }
        if (name.equals(ServerTags.JAVAC_OPTIONS) && !StaticTest.isOptionsValid(value)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidJavacOptions", "{0} : Invalid javac options should start with -", new Object[]{value}));
        }
        if ((name.equals(ServerTags.CLASSPATH_PREFIX) || name.equals(ServerTags.CLASSPATH_SUFFIX) || name.equals(ServerTags.NATIVE_LIBRARY_PATH_PREFIX) || name.equals(ServerTags.NATIVE_LIBRARY_PATH_SUFFIX)) && !StaticTest.isClassPathValid(value)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidClasspath", "{0} Classpath contains invalid path : Check the path", new Object[]{name}));
        }
        if (name.equals(ServerTags.JAVA_HOME) && !StaticTest.isJavaHomeValid(value)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidClasspath", "Warning : (java-home={0}), JDK does not exists in java home", new Object[]{value}));
        }
        if (name.equals(ServerTags.BYTECODE_PREPROCESSORS)) {
            Vector vec = StaticTest.tokens(value);
            for (int i = 0; i < vec.size(); ++i) {
                if (AttrClassName.isValidClassName((String)vec.get(i))) continue;
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidClassName", "Attribute (bytecode-preprocessors={0}), {1} Invalid Class Name", new Object[]{value, (String)vec.get(i)}));
            }
        }
    }

    public void validateRunJDWP(String value, Result result) {
        String runjdwp = value.substring(value.indexOf("jdwp:") + 5);
        int index = 0;
        try {
            if (runjdwp != null) {
                index = runjdwp.indexOf("-X");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String debugStr = null;
        debugStr = index > 0 ? runjdwp.substring(0, index) : runjdwp;
        if (debugStr != null) {
            String[] tokens = debugStr.split(",");
            for (int i = 0; i < tokens.length; ++i) {
                if (tokens[i].indexOf("=") >= 0) continue;
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidJDWPDebugOption", "{0} : Invalid -Xrunjdwp option, please check syntax", new Object[]{debugStr}));
                break;
            }
        }
    }
}

