/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.EjbTimerService;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;

public class EjbTimerServiceTest
extends GenericValidator {
    public EjbTimerServiceTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        if (cce.getChoice().equals("UPDATE")) {
            this.validateAttribute(cce.getName(), (String)cce.getObject(), result, (EjbTimerService)cce.getClassObject());
        }
        return result;
    }

    public void validateAttribute(String name, String value, Result result, EjbTimerService ejbtimer) {
        try {
            if (name.equals(ServerTags.REDELIVERY_INTERVAL_INTERNAL_IN_MILLIS)) {
                this.checkRedeliveryLessThanMinimum(Integer.parseInt(value), Integer.parseInt(ejbtimer.getMinimumDeliveryIntervalInMillis()), result);
            } else if (name.equals(ServerTags.MINIMUM_DELIVERY_INTERVAL_IN_MILLIS)) {
                this.checkRedeliveryLessThanMinimum(Integer.parseInt(ejbtimer.getRedeliveryIntervalInternalInMillis()), Integer.parseInt(value), result);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    private final void checkRedeliveryLessThanMinimum(int redelivery, int minimum, Result result) {
        if (redelivery < minimum) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".redeliveryInterval", "Attribute(id=redelivery-interval-internal-in-millis) : Redelivery-Interval ({0}) should be greater than or equal to Minimum-delivery-interval-in-millis ({1})", new Object[]{new Integer(redelivery), new Integer(minimum)}));
        }
    }
}

