/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;

public class EjbContainerTest
extends GenericValidator {
    public EjbContainerTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        if (cce.getChoice().equals("UPDATE")) {
            this.validateAttribute(cce.getName(), (String)cce.getObject(), result, (EjbContainer)cce.getClassObject());
        }
        return result;
    }

    public void validateAttribute(String name, String value, Result result, EjbContainer ejb) {
        if (name.equals(ServerTags.STEADY_POOL_SIZE)) {
            try {
                int steadyQty = Integer.parseInt(value);
                if (steadyQty > Integer.parseInt(ejb.getMaxPoolSize())) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyPoolMaxPoolError", "Attribute(id=steady-pool-size) : Steady Pool Size ({0}) should be less than or equal to Maximum Pool Size ({1})", new Object[]{String.valueOf(steadyQty), ejb.getMaxPoolSize()}));
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyPoolInvalid", "Steady Pool Size : invalid number"));
            }
        }
        if (name.equals(ServerTags.POOL_RESIZE_QUANTITY)) {
            try {
                int resizeQty = Integer.parseInt(value);
                if (resizeQty > Integer.parseInt(ejb.getMaxPoolSize())) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".resizePoolMaxPoolError", "Attribute(id=pool-resize-quantity) : Pool Resize Qty ({0}) should be less than or equal to Maximum Pool Size ({1})", new Object[]{String.valueOf(resizeQty), ejb.getMaxPoolSize()}));
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".resizeQtyInvalid", "Pool Resize Quantity : invalid number "));
            }
        }
        if (name.equals(ServerTags.CACHE_RESIZE_QUANTITY)) {
            try {
                int cacheResize = Integer.parseInt(value);
                if (cacheResize > Integer.parseInt(ejb.getMaxCacheSize())) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".cacheResizeMaxCacheError", "Attribute(id=cache-resize-quantity) : Cache Resize Quantity ({0})should be less than or equal to Maximum Cache Size ({1})", new Object[]{String.valueOf(cacheResize), ejb.getMaxCacheSize()}));
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".cacheResizeInvalid", "Cache Resize Qty : invalid number "));
            }
        }
    }
}

