/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.tests.ResourceTest;
import java.util.Set;
import java.util.logging.Level;

public class ConnectorResourceTest
extends ResourceTest {
    static boolean checked = false;

    public ConnectorResourceTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        if (cce.getChoice().equals("ADD") || cce.getChoice().equals("OFFLINE")) {
            try {
                ConfigContext context = cce.getConfigContext();
                ConnectorResource conn = this.getConnectorResource(cce);
                boolean isPool = false;
                String pool = conn.getPoolName();
                Domain domain = (Domain)context.getRootConfigBean();
                Resources resource = domain.getResources();
                ConnectorConnectionPool[] connection = resource.getConnectorConnectionPool();
                for (int i = 0; i < connection.length; ++i) {
                    if (!connection[i].getName().equals(pool)) continue;
                    isPool = true;
                }
                if (!isPool) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".connPoolNotAvl", "{0}, Connector Connection Pool Not Available", new Object[]{pool}));
                }
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "domainxmlverifier.exception", e);
            }
        }
        return result;
    }

    protected final String getName(ConfigContextEvent cce) throws ConfigException {
        return this.getConnectorResource(cce).getJndiName();
    }

    protected final boolean isReferenced(ConfigContextEvent cce) throws ConfigException {
        return ServerBeansFactory.isReferenced((ConnectorResource)this.getConnectorResource(cce), (ConfigContext)cce.getConfigContext());
    }

    protected final Set getReferers(ConfigContextEvent cce) throws ConfigException {
        return ServerBeansFactory.getReferers((ConnectorResource)this.getConnectorResource(cce), (ConfigContext)cce.getConfigContext());
    }

    private final ConnectorResource getConnectorResource(ConfigContextEvent cce) throws ConfigException {
        return (ConnectorResource)cce.getValidationTarget();
    }
}

