/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.connectors.ConnectorRuntime;
import java.util.Set;
import java.util.logging.Level;

public class ConnectorConnectionPoolTest
extends GenericValidator {
    int maxPoolSize = 0;

    public ConnectorConnectionPoolTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        String choice = cce.getChoice();
        try {
            if (choice.equals("ADD") || cce.getChoice().equals("OFFLINE")) {
                ConnectorConnectionPool pool = this.getConnectorConnectionPool(cce);
                try {
                    this.maxPoolSize = Integer.parseInt(pool.getMaxPoolSize());
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.validateAttribute(ServerTags.POOL_RESIZE_QUANTITY, pool.getPoolResizeQuantity(), result);
            }
            if (choice.equals("UPDATE")) {
                this.validateAttribute(cce.getName(), (String)cce.getObject(), result);
            }
            if (choice.equals("DELETE") && this.isReferenced(cce)) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotDeleteWhenReferenced", "Connector-connection-pool {0} cannot be deleted because it is referenced by {1} connector-resources", new Object[]{this.getConnectorConnectionPool(cce).getName(), new Integer(this.getReferers(cce).size())}));
            }
        }
        catch (ConfigException ce) {
            _logger.log(Level.WARNING, "domainxmlverifier.exception", ce);
        }
        return result;
    }

    private boolean isReferenced(ConfigContextEvent cce) throws ConfigException {
        return ServerBeansFactory.isReferenced((ConnectorConnectionPool)this.getConnectorConnectionPool(cce), (ConfigContext)cce.getConfigContext());
    }

    private Set getReferers(ConfigContextEvent cce) throws ConfigException {
        return ServerBeansFactory.getReferers((ConnectorConnectionPool)this.getConnectorConnectionPool(cce), (ConfigContext)cce.getConfigContext());
    }

    public void validateAttribute(String name, String value, Result result) {
        if (value == null || value.equals("")) {
            return;
        }
        if (name.equals(ServerTags.MAX_POOL_SIZE)) {
            try {
                this.maxPoolSize = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (name.equals(ServerTags.POOL_RESIZE_QUANTITY)) {
            try {
                int poolResizeQty = Integer.parseInt(value);
                if (this.maxPoolSize > 0 && poolResizeQty > this.maxPoolSize) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidPoolResize", "Attribute(pool-resize-quantity={0}) : Invalid, it is greater than Connector Connection Max Pool Size {1}", new Object[]{value, String.valueOf(this.maxPoolSize)}));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (name.equals(ServerTags.CONNECTION_DEFINITION_NAME)) {
            // empty if block
        }
    }

    public void validateAttribute(String name, String value, String rarName, Result result) {
        try {
            String[] connDefnNames = ConnectorRuntime.getRuntime().getConnectionDefinitionNames(rarName);
            boolean available = false;
            for (int i = 0; i < connDefnNames.length; ++i) {
                if (!value.equals(connDefnNames[i])) continue;
                available = true;
                break;
            }
            if (!available) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".connDefnNotAvl", "Attribute(conndefn={0}) : Invalid Connection Definition Name", new Object[]{value}));
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "domainxmlverifier.exception", e);
        }
    }

    private final ConnectorConnectionPool getConnectorConnectionPool(ConfigContextEvent cce) throws ConfigException {
        return (ConnectorConnectionPool)cce.getValidationTarget();
    }
}

