/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.MdbContainer;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.config.serverbeans.TransactionService;
import com.sun.enterprise.config.serverbeans.WebContainer;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;
import java.util.logging.Level;

public class ConfigTest
extends GenericValidator {
    static boolean checked = false;

    public ConfigTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        if (cce.getChoice().equals("DELETE")) {
            try {
                if (ServerBeansFactory.getConfigs((ConfigContext)cce.getConfigContext()).size() < 2) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".oneConfigRequired", "Atleast One configuration Required - cannot delete "));
                }
                if (ServerBeansFactory.isReferenced((Config)this.getConfig(cce), (ConfigContext)cce.getConfigContext())) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotDeleteReferenced", "Config {0} cannot be deleted because it is referenced by other servers or clusters", new Object[]{this.getConfig(cce).getName()}));
                }
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "domainxmlverifier.error_getting_configbean", e);
            }
        }
        if (cce.getChoice().equals("OFFLINE")) {
            try {
                Servers servers;
                Server[] server;
                Domain domain = (Domain)cce.getConfigContext().getRootConfigBean();
                Configs configs = domain.getConfigs();
                Config[] config = configs.getConfig();
                if (config != null && config.length > 1) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".oneConfigAllowed", "Only one config Allowed"));
                }
                if (config != null && !config[0].getName().equals("server-config")) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidConfig", "{0} : Invalid Config Name - expected \"{1}\"", new Object[]{config[0].getName(), "server-config"}));
                }
                if ((server = (servers = domain.getServers()).getServer()) != null) {
                    String configName;
                    String name = server[0].getName();
                    if (config != null && name.equals(configName = StaticTest.getConfig(cce.getConfigContext()).getName())) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidconfigName", "Config name must not be same as server name"));
                    }
                }
                for (int i = 0; i < config.length; ++i) {
                    HttpService httpservice = config[i].getHttpService();
                    IiopService iiopservice = config[i].getIiopService();
                    AdminService adminservice = config[i].getAdminService();
                    WebContainer webcontainer = config[i].getWebContainer();
                    EjbContainer ejbcontainer = config[i].getEjbContainer();
                    MdbContainer mdbcontainer = config[i].getMdbContainer();
                    LogService logservice = config[i].getLogService();
                    SecurityService securityservice = config[i].getSecurityService();
                    TransactionService transactionservice = config[i].getTransactionService();
                    MonitoringService monitoringservice = config[i].getMonitoringService();
                    JavaConfig javaconfig = config[i].getJavaConfig();
                    ThreadPools threadpools = config[i].getThreadPools();
                    if (httpservice == null) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".httpsrvMissinginConfig", "Http Service Element missing in Config"));
                    }
                    if (iiopservice == null) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".iiopsrvelementMissinginConfig", "IIOP Service Element missing in Config"));
                    }
                    if (adminservice == null) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".admsrvMissinginConfig", "Admin Service Element missing in Config"));
                    }
                    if (webcontainer == null) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".webconMissinginConfig", "Web Container Element missing in Config"));
                    }
                    if (ejbcontainer == null) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".ejbconMissinginConfig", "EJB Container Element missing in Config"));
                    }
                    if (mdbcontainer == null) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".mdbconMissinginConfig", "MDB Container Element missing in Config"));
                    }
                    if (logservice == null) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".logsrvMissinginConfig", "Log Service Element missing in Config"));
                    }
                    if (securityservice == null) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".secsrvMissinginConfig", "Security Service Element missing in Config"));
                    }
                    if (transactionservice == null) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".transrvMissinginConfig", "Transaction Service Element missing in Config"));
                    }
                    if (javaconfig == null) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".javaconfMissinginConfig", "Java Config Element missing in Config"));
                    }
                    if (threadpools == null) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".threadpoolsMissinginConfig", "Thread Pools Element missing in Config"));
                    }
                    if (config[i].getAvailabilityService() == null) continue;
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidAvailaibiltyServiceElement", "Availability Service in config not allowed in PE"));
                }
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "domainxmlverifier.error", e);
            }
        }
        return result;
    }

    private final Config getConfig(ConfigContextEvent cce) throws ConfigException {
        return (Config)cce.getValidationTarget();
    }
}

