/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.admin.common.exception.AFRuntimeException;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigContextEventListener;
import com.sun.enterprise.config.serverbeans.validation.AttrAddress;
import com.sun.enterprise.config.serverbeans.validation.AttrClassName;
import com.sun.enterprise.config.serverbeans.validation.AttrFile;
import com.sun.enterprise.config.serverbeans.validation.AttrInt;
import com.sun.enterprise.config.serverbeans.validation.AttrString;
import com.sun.enterprise.config.serverbeans.validation.AttrType;
import com.sun.enterprise.config.serverbeans.validation.AttrUniqueJNDI;
import com.sun.enterprise.config.serverbeans.validation.DomainCheck;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.StringManagerHelper;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomainMgr
implements ConfigContextEventListener {
    static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.verifier");
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    static HashMap tests = new HashMap();
    private transient long lastModified = 0L;
    public static final String TEST_PACKAGE = "com.sun.enterprise.config.serverbeans.validation.tests.";

    public DomainMgr() {
        this.loadDescriptors();
    }

    private String getTestFile() {
        URL propertiesFile = DomainMgr.class.getClassLoader().getResource("com/sun/enterprise/config/serverbeans/validation/config/ServerTestList.xml");
        return propertiesFile.toString();
    }

    public boolean loadDescriptors() {
        boolean allIsWell = true;
        try {
            tests.clear();
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource(this.getTestFile());
            Document doc = db.parse(is);
            NodeList list = doc.getElementsByTagName("element");
            for (int i = 0; i < list.getLength(); ++i) {
                String key;
                Element e = (Element)list.item(i);
                String elementName = e.getAttribute("name");
                String elementXPath = e.getAttribute("xpath");
                String elementCustomClass = e.getAttribute("custom-class");
                String testName = e.getAttribute("test-name");
                if (null == elementCustomClass || elementCustomClass.length() == 0) {
                    elementCustomClass = testName;
                }
                if ((key = e.getAttribute("key")) != null && key.length() == 0) {
                    key = null;
                }
                Vector<AttrInt> attributes = new Vector<AttrInt>();
                NodeList nl = e.getChildNodes();
                int index = 0;
                for (int j = 0; j < nl.getLength(); ++j) {
                    String nodeName = nl.item(j).getNodeName().trim();
                    String nameValue = null;
                    String typeValue = null;
                    String rangeValue = null;
                    Object saveAttributeValue = null;
                    int maxLengthValue = 0;
                    NamedNodeMap nodeMap = null;
                    AttrType attr = null;
                    Vector<String> vector = null;
                    String regExp = null;
                    String existsFlag = "false";
                    Node n = nl.item(j);
                    if ("attribute".equals(nodeName) || "optional-attribute".equals(nodeName)) {
                        Node checkNode;
                        Node range;
                        Node type;
                        nodeMap = n.getAttributes();
                        Node name = nodeMap.getNamedItem("name");
                        if (name != null) {
                            nameValue = name.getNodeValue();
                        }
                        if ((type = nodeMap.getNamedItem("type")) != null) {
                            typeValue = type.getNodeValue();
                        }
                        if (typeValue.equals("integer") && (range = nodeMap.getNamedItem("range")) != null) {
                            rangeValue = range.getNodeValue();
                        }
                        if (typeValue.equals("string")) {
                            Node regNode;
                            Node enumNode;
                            Node maxLength = nodeMap.getNamedItem("max-length");
                            if (maxLength != null) {
                                maxLengthValue = Integer.parseInt(maxLength.getNodeValue());
                            }
                            if ((enumNode = nodeMap.getNamedItem("enumeration")) != null) {
                                vector = new Vector<String>();
                                String str = enumNode.getNodeValue();
                                StringTokenizer enumTokens = new StringTokenizer(str, ",");
                                int l = 0;
                                while (enumTokens.hasMoreTokens()) {
                                    vector.add(enumTokens.nextToken());
                                    ++l;
                                }
                            }
                            if ((regNode = nodeMap.getNamedItem("regex")) != null) {
                                regExp = regNode.getNodeValue();
                            }
                        }
                        if (typeValue.equals("file") && (checkNode = nodeMap.getNamedItem("exists")) != null) {
                            existsFlag = checkNode.getNodeValue();
                        }
                    }
                    if (nameValue == null || typeValue == null) continue;
                    if (typeValue.equals("integer")) {
                        attr = new AttrInt(nameValue, typeValue, "optional-attribute".equals(nodeName));
                        if (rangeValue != null) {
                            StringTokenizer tokens = new StringTokenizer(rangeValue, ",");
                            String low = tokens.nextToken();
                            String high = tokens.nextToken();
                            if (!low.equals("NA")) {
                                ((AttrInt)attr).setLowRange(Integer.parseInt(low));
                            }
                            if (!high.equals("NA")) {
                                ((AttrInt)attr).setHighRange(Integer.parseInt(high));
                            }
                        }
                    } else if (typeValue.equals("file")) {
                        attr = new AttrFile(nameValue, typeValue, "optional-attribute".equals(nodeName));
                        if (existsFlag.equals("true")) {
                            ((AttrFile)attr).setCheckExists(true);
                        }
                    } else if (typeValue.equals("classname")) {
                        attr = new AttrClassName(nameValue, typeValue, "optional-attribute".equals(nodeName));
                    } else if (typeValue.equals("address")) {
                        attr = new AttrAddress(nameValue, typeValue, "optional-attribute".equals(nodeName));
                    } else if (typeValue.equals("jndi-unique")) {
                        attr = new AttrUniqueJNDI(nameValue, typeValue, "optional-attribute".equals(nodeName));
                    } else if (typeValue.equals("string")) {
                        attr = new AttrString(nameValue, typeValue, "optional-attribute".equals(nodeName));
                        ((AttrString)attr).setMaxLength(maxLengthValue);
                        ((AttrString)attr).setEnumstring(vector);
                        ((AttrString)attr).setRegExpression(regExp);
                    }
                    if (attr == null) continue;
                    attributes.add(index++, (AttrInt)attr);
                }
                ValidationDescriptor desc = new ValidationDescriptor(elementName, elementXPath, elementCustomClass, key, attributes);
                GenericValidator validator = this.getGenericValidator(desc);
                if (validator == null) continue;
                tests.put(testName, validator);
            }
        }
        catch (ParserConfigurationException e) {
            _logger.log(Level.WARNING, "parser_error", e);
            allIsWell = false;
        }
        catch (SAXException e) {
            _logger.log(Level.WARNING, "sax_error", e);
            allIsWell = false;
        }
        catch (IOException e) {
            _logger.log(Level.WARNING, "error_loading_xmlfile", e);
            allIsWell = false;
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "error", e);
            allIsWell = false;
        }
        return allIsWell;
    }

    GenericValidator getGenericValidator(ValidationDescriptor v) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Class c = this.getValidatorClass(v.getCustomValidatorClass());
        try {
            Constructor con = c.getConstructor(ValidationDescriptor.class);
            return (GenericValidator)con.newInstance(v);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    Class getValidatorClass(String className) {
        Class c;
        String cn = TEST_PACKAGE + className + "Test";
        try {
            c = Class.forName(cn);
        }
        catch (ClassNotFoundException cnfe2) {
            c = GenericValidator.class;
        }
        _logger.log(Level.CONFIG, "validator using class \"" + c.getName() + "\" to validate \"" + cn + "\"");
        return c;
    }

    public Result check(ConfigContextEvent cce) {
        String name = cce.getName();
        String beanName = cce.getBeanName();
        Result result = null;
        if (name == null && beanName == null) {
            return result;
        }
        DomainCheck validator = (DomainCheck)tests.get(name);
        if (validator == null && beanName != null) {
            validator = (DomainCheck)tests.get(beanName);
        }
        try {
            if (validator != null) {
                result = validator.validate(cce);
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "domainxmlverifier.error_on_validation", e);
        }
        return result;
    }

    public void postAccessNotification(ConfigContextEvent ccce) {
    }

    public void postChangeNotification(ConfigContextEvent ccce) {
    }

    public void preAccessNotification(ConfigContextEvent ccce) {
    }

    public void preChangeNotification(ConfigContextEvent cce) {
        Result result = this.check(cce);
        if (result != null && result.getStatus() == 1) {
            throw new AFRuntimeException(result.getErrorDetails().toString());
        }
    }
}

