/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.config.serverbeans.validation.AttrType;
import com.sun.enterprise.config.serverbeans.validation.GenericDesc;

public class AttrInt
extends AttrType {
    public static final int IGNORE_LOW = Integer.MIN_VALUE;
    public static final int IGNORE_HIGH = 0x7FFFFFF6;
    int highRange = 0x7FFFFFF6;
    int lowRange = Integer.MIN_VALUE;

    public AttrInt(String name, String type, boolean optional) {
        super(name, type, optional);
    }

    public int getHighRange() {
        return this.highRange;
    }

    public int getLowRange() {
        return this.lowRange;
    }

    public void setHighRange(int high) {
        this.highRange = high;
    }

    public void setLowRange(int low) {
        this.lowRange = low;
    }

    public void validate(Object o, GenericDesc genDesc) {
        super.validate(o, genDesc);
        int tmp = 0;
        boolean success = true;
        if (o == null || o.equals("")) {
            return;
        }
        try {
            tmp = Integer.parseInt(o.toString());
        }
        catch (NumberFormatException n) {
            genDesc.result.failed(genDesc.smh.getLocalString(this.getClass().getName() + ".invalidInteger", "Attribute({0}={1}) : {2} Invalid integer", new Object[]{genDesc.attrName, o, o}));
            success = false;
        }
        if (success && (this.lowRange != Integer.MIN_VALUE && tmp < this.lowRange || this.highRange != 0x7FFFFFF6 && tmp > this.highRange)) {
            if (this.lowRange == 0 && this.highRange == 0x7FFFFFF6) {
                genDesc.result.failed(genDesc.smh.getLocalString(this.getClass().getName() + ".invalidIntegerNegative", "Attribute({0}={1}) : {2} Invalid Value, Cannot be a negative number", new Object[]{genDesc.attrName, String.valueOf(tmp), String.valueOf(tmp)}));
                return;
            }
            genDesc.result.failed(genDesc.smh.getLocalString(this.getClass().getName() + ".invalidIntegerRange", "Attribute({0}={1}) : {2} Invalid Value, Valid Range {3},{4}", new Object[]{genDesc.attrName, String.valueOf(tmp), String.valueOf(tmp), String.valueOf(this.lowRange), String.valueOf(this.highRange)}));
        }
    }
}

