/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.backup.util;

import com.sun.enterprise.config.backup.util.FileListerRelative;
import com.sun.enterprise.config.backup.util.OS;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class FileUtils {
    private static final int BUFFER_SIZE = 65536;
    private static final char[] ILLEGAL_FILENAME_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|'};
    private static final String ILLEGAL_FILENAME_STRING = "\\/:*?\"<>|";
    private static final char REPLACEMENT_CHAR = '_';
    private static final char BLANK = ' ';
    private static final char DOT = '.';
    private static String TMPFILENAME = "scratch";

    private FileUtils() {
    }

    public static boolean safeIsDirectory(File f) {
        return f != null && f.exists() && f.isDirectory();
    }

    public static boolean safeIsDirectory(String s) {
        return FileUtils.safeIsDirectory(new File(s));
    }

    public static String safeGetCanonicalPath(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return f.getAbsolutePath();
        }
    }

    public static File safeGetCanonicalFile(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f.getAbsoluteFile();
        }
    }

    public static boolean isZip(String filename) {
        return FileUtils.hasExtensionIgnoreCase(filename, ".zip");
    }

    public static boolean isZip(File f) {
        return FileUtils.hasExtensionIgnoreCase(f, ".zip");
    }

    public static void whack(File parent) {
        if (FileUtils.safeIsDirectory(parent)) {
            File[] kids = parent.listFiles();
            for (int i = 0; i < kids.length; ++i) {
                File f = kids[i];
                if (f.isDirectory()) {
                    FileUtils.whack(f);
                }
                if (f.delete()) continue;
                f.deleteOnExit();
            }
        }
        parent.delete();
    }

    public static boolean protect(File f) {
        if (!f.exists()) {
            return true;
        }
        if (OS.isUNIX()) {
            return FileUtils.protectUNIX(f);
        }
        return FileUtils.protectWindows(f);
    }

    public static boolean makeExecutable(File f) {
        if (!OS.isUNIX()) {
            return true;
        }
        if (!f.exists()) {
            return true;
        }
        if (!f.isDirectory()) {
            return FileUtils.makeExecutable(f.getAbsolutePath());
        }
        return FileUtils.makeExecutable(FileUtils.getFilesInDir(f));
    }

    public static void copyTree(File din, File dout) throws IOException {
        if (!FileUtils.safeIsDirectory(din)) {
            throw new IllegalArgumentException("Source isn't a directory");
        }
        dout.mkdirs();
        if (!FileUtils.safeIsDirectory(dout)) {
            throw new IllegalArgumentException("Can't create destination directory");
        }
        FileListerRelative flr = new FileListerRelative(din);
        String[] files = flr.getFiles();
        for (int i = 0; i < files.length; ++i) {
            File fin = new File(din, files[i]);
            File fout = new File(dout, files[i]);
            FileUtils.copy(fin, fout);
        }
    }

    private static boolean hasExtension(String filename, String ext) {
        if (filename == null || filename.length() <= 0) {
            return false;
        }
        return filename.endsWith(ext);
    }

    private static boolean hasExtension(File f, String ext) {
        if (f == null || !f.exists()) {
            return false;
        }
        return f.getName().endsWith(ext);
    }

    private static boolean hasExtensionIgnoreCase(String filename, String ext) {
        if (filename == null || filename.length() <= 0) {
            return false;
        }
        return filename.toLowerCase().endsWith(ext.toLowerCase());
    }

    private static boolean hasExtensionIgnoreCase(File f, String ext) {
        if (f == null || !f.exists()) {
            return false;
        }
        return f.getName().toLowerCase().endsWith(ext.toLowerCase());
    }

    private static void copy(InputStream inStream, OutputStream outStream) throws IOException {
        FileUtils.copyWithoutClose(inStream, outStream);
        inStream.close();
        outStream.close();
    }

    private static void copyWithoutClose(InputStream inStream, OutputStream outStream) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(inStream, 65536);
        BufferedOutputStream bos = new BufferedOutputStream(outStream, 65536);
        byte[] buf = new byte[65536];
        int len = 0;
        while (len != -1) {
            try {
                len = bis.read(buf, 0, buf.length);
            }
            catch (EOFException eof) {
                break;
            }
            if (len == -1) continue;
            bos.write(buf, 0, len);
        }
        bos.flush();
    }

    private static void copy(String from, String to) throws IOException {
        if (from == null || to == null) {
            throw new IllegalArgumentException("null or empty filename argument");
        }
        File fin = new File(from);
        File fout = new File(to);
        FileUtils.copy(fin, fout);
    }

    private static void copy(File fin, File fout) throws IOException {
        if (FileUtils.safeIsDirectory(fin)) {
            FileUtils.copyTree(fin, fout);
            return;
        }
        if (!fin.exists()) {
            throw new IllegalArgumentException("File source doesn't exist");
        }
        if (!FileUtils.safeIsDirectory(fout.getParentFile())) {
            fout.getParentFile().mkdirs();
        }
        FileUtils.copy(new FileInputStream(fin), new FileOutputStream(fout));
    }

    private static boolean protectUNIX(File f) {
        String moreFiles = null;
        String fname = f.getAbsolutePath();
        String mode = "0600";
        if (f.isDirectory()) {
            mode = "0700";
            moreFiles = FileUtils.getFilesInDir(f);
        }
        String cmd = "chmod " + mode + " " + fname;
        try {
            boolean ret;
            Process p = Runtime.getRuntime().exec(cmd);
            boolean bl = ret = p.waitFor() == 0;
            if (moreFiles != null && moreFiles.length() > 0) {
                cmd = "chmod 0600 " + moreFiles;
                p = Runtime.getRuntime().exec(cmd);
                ret = p.waitFor() == 0;
            }
            return ret;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean protectWindows(File f) {
        String fname = f.getAbsolutePath();
        String uname = System.getProperty("user.name");
        String cmd = "cacls " + fname + " /G " + uname + ":F";
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
            writer.write(89);
            writer.newLine();
            writer.flush();
            return p.waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean makeExecutable(String s) {
        if (s == null || s.length() <= 0) {
            return true;
        }
        String cmd = "chmod 0744 " + s;
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            return p.waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String getFilesInDir(File dir) {
        StringBuffer sb = new StringBuffer();
        if (!dir.isDirectory()) {
            return null;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length <= 0) {
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) continue;
            sb.append(files[i].getAbsolutePath());
            sb.append(' ');
        }
        if (sb.length() <= 0) {
            return null;
        }
        return sb.toString();
    }
}

