/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.controllers;

import com.sun.enterprise.admin.common.JMSDestinationInfo;
import com.sun.enterprise.admin.common.JMSObjectInfo;
import com.sun.enterprise.admin.common.JMSStatus;
import com.sun.enterprise.admin.common.exception.JMSAdminException;
import com.sun.enterprise.admin.servermodel.beans.JMSComponentBean;
import com.sun.enterprise.admin.servermodel.context.ContextHolder;
import com.sun.enterprise.admin.servermodel.controllers.Controller;
import com.sun.enterprise.admin.servermodel.controllers.SOMRequestDispatcher;
import com.sun.enterprise.admin.util.Assert;
import com.sun.enterprise.admin.util.Debug;
import com.sun.enterprise.admin.util.HostAndPort;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JMSComponentController
implements Controller {
    private static final String CREATE_JMS_OBJECT = "createJMSObject";
    private static final String LIST_JMS_OBJECTS = "listJMSObjects";
    private static final String DELETE_JMS_OBJECT = "deleteJMSObject";
    private static final String CREATE_JMS_DESTINATION = "createJMSDestination";
    private static final String DELETE_JMS_DESTINATION = "deleteJMSDestination";
    private static final String LIST_JMS_DESTINATIONS = "listJMSDestinations";
    private static final String PING_JMS_SERVICE = "JMSPing";
    private JMSComponentBean controllable;

    public JMSComponentController(JMSComponentBean component) {
        this.controllable = component;
    }

    public HostAndPort getBrokerHostAndPort() throws JMSAdminException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public void startBroker() throws JMSAdminException {
    }

    public void stopBroker() throws JMSAdminException {
    }

    public void restartBroker() throws JMSAdminException {
    }

    public void createDestination(String destinationName, String destinationType, Properties properties) throws JMSAdminException {
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.util.Properties"};
        Object[] params = new Object[]{destinationName, destinationType, properties};
        this.invoke(CREATE_JMS_DESTINATION, params, signature);
    }

    public void purgeDestination(String destinationName, String destinationType) throws JMSAdminException {
    }

    public void destroyDestination(String destinationName, String destinationType) throws JMSAdminException {
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        Object[] params = new Object[]{destinationName, destinationType};
        this.invoke(DELETE_JMS_DESTINATION, params, signature);
    }

    public JMSDestinationInfo[] getAllDestinations(String destType) throws JMSAdminException {
        JMSDestinationInfo[] jmsDestinations = (JMSDestinationInfo[])this.invoke(LIST_JMS_DESTINATIONS, new Object[]{destType}, new String[]{"java.lang.String"});
        return jmsDestinations;
    }

    public Properties getBrokerProperties() throws JMSAdminException {
        return new Properties();
    }

    public Properties getDestinationProperties(String destinationName, String destinationType) throws JMSAdminException {
        return new Properties();
    }

    public void createAdministeredObject(String jndiName, String objectType, Properties properties) throws JMSAdminException {
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.util.Properties"};
        Object[] params = new Object[]{jndiName, objectType, properties};
        this.invoke(CREATE_JMS_OBJECT, params, signature);
    }

    public void deleteAdministeredObject(String jndiName) throws JMSAdminException {
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{jndiName};
        this.invoke(DELETE_JMS_OBJECT, params, signature);
    }

    public String getStatus() throws JMSAdminException {
        JMSStatus status = (JMSStatus)this.invoke(PING_JMS_SERVICE, null, null);
        Assert.assertit(status != null, "null value returned");
        return status.getStatusString();
    }

    public String getStatus(String userName, String password, int port) throws JMSAdminException {
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "int"};
        Object[] params = new Object[]{userName, password, new Integer(port)};
        JMSStatus status = (JMSStatus)this.invoke(PING_JMS_SERVICE, params, signature);
        Assert.assertit(status != null, "null value returned");
        return status.getStatusString();
    }

    public void updateAdministeredObject(String jndiName, Properties props) throws JMSAdminException {
    }

    public Properties getAdministeredObjectProperties(String jndiName) throws JMSAdminException {
        return new Properties();
    }

    public JMSObjectInfo[] getAdministeredObjects(String type) throws JMSAdminException {
        JMSObjectInfo[] jmsObjects = (JMSObjectInfo[])this.invoke(LIST_JMS_OBJECTS, new Object[]{type}, new String[]{"java.lang.String"});
        return jmsObjects;
    }

    public void addUser(String user) throws JMSAdminException {
    }

    public void addUserToGroup(String user, String group) throws JMSAdminException {
    }

    public void deleteUser(String user) throws JMSAdminException {
    }

    public void deleteUserFromGroup(String user, String group) throws JMSAdminException {
    }

    public String[] getAllUsers() throws JMSAdminException {
        return null;
    }

    public String[] getAllUsersInGroup(String group) throws JMSAdminException {
        return null;
    }

    public String[] getAllGroups() throws JMSAdminException {
        return null;
    }

    private Object invoke(String operationName, Object[] params, String[] signature) throws JMSAdminException {
        Object value = null;
        ObjectName mbeanName = null;
        try {
            mbeanName = new ObjectName(this.controllable.getIdentifier());
        }
        catch (MalformedObjectNameException mfone) {
            throw new JMSAdminException(mfone.getLocalizedMessage());
        }
        Assert.assertit(mbeanName != null, "null value returned");
        try {
            ContextHolder ctxHolder = this.controllable.getContextHolder();
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            value = dispatcher.invoke(mbeanName, operationName, params, signature);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            if (e instanceof JMSAdminException) {
                throw (JMSAdminException)e;
            }
            throw new JMSAdminException(e.getLocalizedMessage());
        }
        return value;
    }
}

