/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.controllers;

import com.sun.enterprise.admin.common.exception.AFException;
import com.sun.enterprise.admin.servermodel.beans.IiopListener;
import com.sun.enterprise.admin.servermodel.context.ContextHolder;
import com.sun.enterprise.admin.servermodel.controllers.Controller;
import com.sun.enterprise.admin.servermodel.controllers.SOMRequestDispatcher;
import com.sun.enterprise.admin.util.ArgChecker;
import com.sun.enterprise.admin.util.Assert;
import com.sun.enterprise.admin.util.StringValidator;
import javax.management.ObjectName;

public class IiopListenerComponentController
implements Controller {
    private static final String IS_SSL_CREATED = "isSslCreated";
    private static final String CREATE_SSL = "createSsl";
    private static final String DELETE_SSL = "deleteSsl";
    private IiopListener component;

    public IiopListenerComponentController(IiopListener component) {
        this.component = component;
    }

    public boolean isSSLCreated() throws AFException {
        Object value = this.invoke(IS_SSL_CREATED, null, null);
        Assert.assertit(value != null, "null value returned");
        return (Boolean)value;
    }

    public void createSSL(String certNickName) throws AFException {
        ArgChecker.checkValid(certNickName, "certNickName", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean", "java.lang.Boolean", "java.lang.Boolean"};
        Object[] params = new Object[]{certNickName, null, null, null, null, null, null, null};
        this.invoke(CREATE_SSL, params, signature);
    }

    public void deleteSSL() throws AFException {
        this.invoke(DELETE_SSL, null, null);
    }

    private Object invoke(String operation, Object[] params, String[] signature) throws AFException {
        try {
            ContextHolder ctxHolder = this.component.getContextHolder();
            ObjectName mbeanName = new ObjectName(this.component.getIdentifier());
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            return dispatcher.invoke(mbeanName, operation, params, signature);
        }
        catch (Exception e) {
            if (e instanceof AFException) {
                throw (AFException)e;
            }
            throw new AFException(e.getLocalizedMessage());
        }
    }
}

