/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.context;

import com.sun.enterprise.admin.servermodel.context.Context;
import com.sun.enterprise.admin.util.ArgChecker;
import com.sun.enterprise.admin.util.StringValidator;

public class NameSpaceContext
implements Context {
    private final String identifier;
    private final NameSpaceContext parentCtx;

    public NameSpaceContext(String identifier, NameSpaceContext parentCtx) {
        ArgChecker.checkValid(identifier, "identifier", StringValidator.getInstance());
        ArgChecker.checkValid(parentCtx, "parentCtx");
        this.identifier = identifier;
        this.parentCtx = parentCtx;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getNameSpaceIdentifier() {
        String nsIdentifier = this.identifier;
        if (this.parentCtx != null) {
            nsIdentifier = this.parentCtx.getNameSpaceIdentifier() + '.' + nsIdentifier;
        }
        return nsIdentifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        boolean isEqual = false;
        if (o instanceof NameSpaceContext) {
            NameSpaceContext that = (NameSpaceContext)o;
            isEqual = that.getNameSpaceIdentifier().equals(this.getNameSpaceIdentifier());
        }
        return isEqual;
    }
}

