/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.context;

import com.sun.enterprise.admin.servermodel.context.AdminContext;
import com.sun.enterprise.admin.servermodel.context.AuthenticationContext;
import com.sun.enterprise.admin.servermodel.context.Context;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class ContextHolder
implements Serializable {
    private final ArrayList contexts = new ArrayList(5);

    public synchronized void put(Context ctx) {
        if (ctx != null) {
            if (this.contexts.contains(ctx)) {
                this.contexts.remove(ctx);
            }
            this.contexts.add(ctx);
        }
    }

    public synchronized boolean remove(Context ctx) {
        if (ctx != null) {
            return this.contexts.remove(ctx);
        }
        return false;
    }

    public AdminContext getAdminContext() {
        return (AdminContext)this.getContext(AdminContext.class);
    }

    public AuthenticationContext getAuthenticationContext() {
        return (AuthenticationContext)this.getContext(AuthenticationContext.class);
    }

    private synchronized Context getContext(Class contextClass) {
        Iterator it = this.contexts.iterator();
        while (it.hasNext()) {
            Context ctx = (Context)it.next();
            if (ctx.getClass() != contextClass) continue;
            return ctx;
        }
        return null;
    }
}

