/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.beans;

import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.common.exception.AFException;
import com.sun.enterprise.admin.servermodel.beans.ACL;
import com.sun.enterprise.admin.servermodel.beans.HttpListener;
import com.sun.enterprise.admin.servermodel.beans.Mime;
import com.sun.enterprise.admin.servermodel.beans.ServerComponent;
import com.sun.enterprise.admin.servermodel.beans.VirtualServerClass;
import com.sun.enterprise.admin.servermodel.controllers.Controller;
import com.sun.enterprise.admin.servermodel.controllers.HttpServiceComponentController;
import com.sun.enterprise.admin.servermodel.util.ServerModelIterator;
import com.sun.enterprise.admin.util.ArgChecker;
import com.sun.enterprise.admin.util.Assert;
import com.sun.enterprise.admin.util.Debug;
import com.sun.enterprise.admin.util.ExceptionUtil;
import com.sun.enterprise.admin.util.StringValidator;
import java.io.Serializable;
import javax.management.ObjectName;

public class HttpServiceComponentBean
extends ServerComponent
implements Serializable {
    private transient HttpServiceComponentController controller = new HttpServiceComponentController(this);

    public HttpServiceComponentBean(String identifier) {
        super(identifier);
    }

    public Controller getController() {
        return this.controller;
    }

    public void createHttpListener(String id, String address, int port, String defaultVirtualServer, String serverName) throws AFException {
        this.controller.createHttpListener(id, address, port, defaultVirtualServer, serverName);
    }

    public void deleteHttpListener(String id) throws AFException {
        this.controller.deleteHttpListener(id);
    }

    public HttpListener getHttpListener(String id) {
        ArgChecker.checkValid(id, "id", StringValidator.getInstance());
        String instanceName = this.getInstanceName();
        Assert.assertit(instanceName != null, "null value returned");
        ObjectName mbeanName = ObjectNames.getHttpListenerObjectName(instanceName, id);
        Assert.assertit(mbeanName != null, "null value returned");
        HttpListener httpListener = new HttpListener(mbeanName.toString(), id);
        httpListener.setContextHolder(this.getContextHolder());
        return httpListener;
    }

    public ServerModelIterator getHttpListeners() throws AFException {
        return this.controller.getHttpListeners();
    }

    public boolean isHttpQosCreated() throws AFException {
        return this.controller.isHttpQosCreated();
    }

    public void createHttpQos() throws AFException {
        this.controller.createHttpQos();
    }

    public void removeHttpQos() throws AFException {
        this.controller.removeHttpQos();
    }

    public void createMime(String id, String file) throws AFException {
        this.controller.createMime(id, file);
    }

    public void removeMime(String id) throws AFException {
        this.controller.removeMime(id);
    }

    public ServerModelIterator getMimes() throws AFException {
        return this.controller.getMimes();
    }

    public Mime getMime(String id) {
        ArgChecker.checkValid(id, "id", StringValidator.getInstance());
        String instanceName = this.getInstanceName();
        ObjectName mbeanName = ObjectNames.getMimeObjectName(instanceName, id);
        Assert.assertit(mbeanName != null, "null value returned");
        Debug.println("HttpServiceComponentBean.getMime: mbean = " + mbeanName);
        Mime mime = new Mime(mbeanName.toString(), id);
        mime.setContextHolder(this.getContextHolder());
        return mime;
    }

    public void createAcl(String id, String file) throws AFException {
        this.controller.createAcl(id, file);
    }

    public void removeAcl(String id) throws AFException {
        this.controller.removeAcl(id);
    }

    public ServerModelIterator getAcls() throws AFException {
        return this.controller.getAcls();
    }

    public ACL getAcl(String id) {
        ArgChecker.checkValid(id, "id", StringValidator.getInstance());
        String instanceName = this.getInstanceName();
        ObjectName mbeanName = ObjectNames.getAclObjectName(instanceName, id);
        Assert.assertit(mbeanName != null, "null value returned");
        Debug.println("HttpServiceComponentBean.getAcl: mbean = " + mbeanName);
        ACL acl = new ACL(mbeanName.toString(), id);
        acl.setContextHolder(this.getContextHolder());
        return acl;
    }

    public VirtualServerClass getVirtualServerClass(String classId) {
        ArgChecker.checkValid(classId, "classId", StringValidator.getInstance());
        String instanceName = this.getInstanceName();
        Assert.assertit(instanceName != null, "null value returned");
        ObjectName mbeanName = ObjectNames.getVirtualServerClassObjectName(instanceName, classId);
        Assert.assertit(mbeanName != null, "null value returned");
        Debug.println("HttpServiceComponentBean.getVirtualServerClass: mbean = " + mbeanName);
        VirtualServerClass component = new VirtualServerClass(mbeanName.toString(), classId);
        component.setContextHolder(this.getContextHolder());
        return component;
    }

    public String getInstanceName() {
        String instanceName = null;
        try {
            String identifier = this.getIdentifier();
            ObjectName mbeanName = new ObjectName(identifier);
            instanceName = mbeanName.getKeyProperty("instance-name");
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return instanceName;
    }
}

