/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats.spi;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.JVMThreadInfoStats;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatisticImpl;
import java.lang.management.ThreadInfo;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class JVMThreadInfoStatsImpl
implements JVMThreadInfoStats {
    private GenericStatsImpl baseStatsImpl;
    private static final String STATS_INTERFACE_NAME = "com.sun.enterprise.admin.monitor.stats.JVMThreadInfoStats";
    private ThreadInfo info;
    private long initTime;
    MutableCountStatistic blockedCount;
    MutableCountStatistic blockedTime;
    MutableCountStatistic lockOwnerId;
    MutableCountStatistic threadId;
    MutableCountStatistic waitingCount;
    MutableCountStatistic waitingTime;
    static String NEWLINE = "\n";

    public JVMThreadInfoStatsImpl(ThreadInfo tInfo) {
        try {
            this.baseStatsImpl = new GenericStatsImpl(STATS_INTERFACE_NAME, (Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initTime = System.currentTimeMillis();
        this.info = tInfo;
        this.initializeStatistics();
    }

    public CountStatistic getBlockedCount() {
        long blockCount = this.info.getBlockedCount();
        this.blockedCount.setCount(blockCount);
        return (CountStatistic)this.blockedCount.unmodifiableView();
    }

    public CountStatistic getBlockedTime() {
        long blockTime = this.info.getBlockedTime();
        this.blockedTime.setCount(blockTime);
        return (CountStatistic)this.blockedTime.unmodifiableView();
    }

    public StringStatistic getLockName() {
        String lockName = this.info.getLockName();
        if (lockName == null) {
            lockName = "";
        }
        return new StringStatisticImpl(lockName, "LockName", "String", "Name of the monitor lock, that this thread is waiting on", this.initTime, System.currentTimeMillis());
    }

    public CountStatistic getLockOwnerId() {
        long id = this.info.getLockOwnerId();
        this.lockOwnerId.setCount(id);
        return (CountStatistic)this.lockOwnerId.unmodifiableView();
    }

    public StringStatistic getLockOwnerName() {
        String lockOwnerName = this.info.getLockOwnerName();
        if (lockOwnerName == null) {
            lockOwnerName = "";
        }
        return new StringStatisticImpl(lockOwnerName, "LockOwnerName", "String", "Name of the thread holding the monitor lock", this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getStackTrace() {
        StackTraceElement[] trace = this.info.getStackTrace();
        String traceString = new String();
        if (trace != null) {
            for (int i = 0; i < trace.length; ++i) {
                traceString = traceString.concat(trace[i].toString());
                traceString = traceString.concat(NEWLINE);
            }
        }
        return new StringStatisticImpl(traceString, "StackTrace", "String", "Stack trace of the thread", this.initTime, System.currentTimeMillis());
    }

    public CountStatistic getThreadId() {
        long id = this.info.getThreadId();
        this.threadId.setCount(id);
        return (CountStatistic)this.threadId.unmodifiableView();
    }

    public StringStatistic getThreadName() {
        String name = this.info.getThreadName();
        return new StringStatisticImpl(name, "ThreadName", "String", "Name of the thread", this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getThreadState() {
        return new StringStatisticImpl(this.info.getThreadState().toString(), "ThreadState", "String", "State of the thread", this.initTime, System.currentTimeMillis());
    }

    public CountStatistic getWaitedCount() {
        long waitCount = this.info.getWaitedCount();
        this.waitingCount.setCount(waitCount);
        return (CountStatistic)this.waitingCount.unmodifiableView();
    }

    public CountStatistic getWaitedTime() {
        long waitTime = this.info.getWaitedTime();
        this.waitingTime.setCount(waitTime);
        return (CountStatistic)this.waitingTime.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this.baseStatsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private void initializeStatistics() {
        CountStatisticImpl c = new CountStatisticImpl("BlockedTime", "milliseconds");
        this.blockedTime = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl("BlockedCount");
        this.blockedCount = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl("LockOwnerId");
        this.lockOwnerId = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl("ThreadId");
        this.threadId = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl("WaitingCount");
        this.waitingCount = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl("WaitingTime", "milliseconds");
        this.waitingTime = new MutableCountStatisticImpl(c);
    }
}

