/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi.reconfig;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.MonitoringLevelChangeEvent;
import com.sun.enterprise.admin.event.MonitoringLevelChangeEventListener;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.ChangeHandler;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.MonitoringThreadContext;

public class MonitoringConfigChangeListener
implements MonitoringLevelChangeEventListener {
    private final ChangeHandler delegate;
    public static final String EJB_CONTAINER = "ejb-container";
    public static final String WEB_CONTAINER = "web-container";
    public static final String THREAD_POOL = "thread-pool";
    public static final String ORB = "orb";
    public static final String TRANSACTION_SERVICE = "transaction-service";
    public static final String HTTP_SERVICE = "http-service";
    public static final String JDBC_CONN_POOL = "jdbc-connection-pool";
    public static final String CONNECTOR_CONN_POOL = "connector-connection-pool";
    public static final String CONNECTOR_SERVICE = "connector-service";
    public static final String JMS_SERVICE = "jms-service";
    public static final String JNDI = "jndi";
    public static final String JVM = "jvm";

    public MonitoringConfigChangeListener(ChangeHandler delegate) {
        this.delegate = delegate;
    }

    public synchronized void monitoringLevelChanged(MonitoringLevelChangeEvent event) throws AdminEventListenerException {
        String component = event.getComponentName();
        String from = event.getOldMonitoringLevel();
        String to = event.getNewMonitoringLevel();
        MonitoringThreadContext.setEventToThreadLocal((AdminEvent)event);
        this.handleAllAffectedTypes(component, from, to);
        MonitoringThreadContext.removeEventFromThreadLocal();
    }

    private void handleAllAffectedTypes(String component, String from, String to) {
        MonitoredObjectType[] types = this.name2Types(component);
        MonitoringLevel oLevel = MonitoringLevel.instance(from);
        MonitoringLevel nLevel = MonitoringLevel.instance(to);
        for (int i = 0; i < types.length; ++i) {
            this.delegate.handleChange(types[i], oLevel, nLevel);
        }
    }

    private MonitoredObjectType[] name2Types(String component) {
        MonitoredObjectType[] types = new MonitoredObjectType[]{};
        if (EJB_CONTAINER.equals(component)) {
            types = MonitoredObjectType.EJB_TYPES;
        } else if (WEB_CONTAINER.equals(component)) {
            types = new MonitoredObjectType[]{MonitoredObjectType.SERVLET};
        } else if (THREAD_POOL.equals(component)) {
            types = new MonitoredObjectType[]{MonitoredObjectType.THREAD_POOL};
        } else if (ORB.equals(component)) {
            types = new MonitoredObjectType[]{MonitoredObjectType.ORB};
        } else if (HTTP_SERVICE.equals(component)) {
            types = MonitoredObjectType.HTTP_SERVICE_TYPES;
        } else if (TRANSACTION_SERVICE.equals(component)) {
            types = new MonitoredObjectType[]{MonitoredObjectType.TRANSACTION_SERVICE};
        } else if (JDBC_CONN_POOL.equals(component)) {
            types = new MonitoredObjectType[]{MonitoredObjectType.JDBC_CONN_POOL};
        } else if (CONNECTOR_SERVICE.equals(component)) {
            types = new MonitoredObjectType[]{MonitoredObjectType.CONNECTOR_SERVICE};
        } else if (JVM.equals(component)) {
            types = new MonitoredObjectType[]{MonitoredObjectType.JVM};
        }
        return types;
    }
}

