/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi.reconfig;

import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.StatsHolder;
import com.sun.enterprise.admin.monitor.registry.spi.MonitoringRegistrationHelper;
import com.sun.enterprise.admin.monitor.registry.spi.ValueListMap;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.ChangeHandler;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

class JVMChangeHandler
implements ChangeHandler {
    private final ChangeHandler successor;
    private final ValueListMap listeners;
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    JVMChangeHandler(ChangeHandler successor, ValueListMap listeners) {
        this.successor = successor;
        this.listeners = listeners;
    }

    public void handleChange(MonitoredObjectType t, MonitoringLevel from, MonitoringLevel to) {
        if (this.isJvmType(t)) {
            this.handleChange(from, to, t);
        } else {
            this.successor.handleChange(t, from, to);
        }
    }

    private boolean isJvmType(MonitoredObjectType t) {
        return t == MonitoredObjectType.JVM;
    }

    private void handleChange(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType t) {
        boolean threadInfo;
        if (this.off2Low(from, to) || this.off2High(from, to)) {
            threadInfo = false;
            this.notifyListeners(from, to, t);
            if (to == MonitoringLevel.HIGH) {
                threadInfo = true;
            }
            this.registerMBeans(threadInfo);
        }
        if (this.low2Off(from, to) || this.high2Off(from, to)) {
            threadInfo = false;
            if (from == MonitoringLevel.HIGH) {
                threadInfo = true;
            }
            this.unregisterMBeans(threadInfo);
            this.notifyListeners(from, to, t);
        }
        if (this.low2High(from, to)) {
            this.notifyListeners(from, to, t);
            this.registerThreadInfoMBeans();
        }
        if (this.high2Low(from, to)) {
            this.unregisterThreadInfoMBeans();
            this.notifyListeners(from, to, t);
        }
    }

    private void notifyListeners(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType t) {
        logger.finer("DynamicReconfigurator: Now notifying the listeners for jvm stats --- from = " + from.toString() + " to = " + to.toString());
        Map l = (Map)this.listeners.get(t);
        if (l == null) {
            return;
        }
        Iterator it = l.keySet().iterator();
        while (it.hasNext()) {
            MonitoringLevelListener ml = (MonitoringLevelListener)it.next();
            ml.changeLevel(from, to, t);
        }
    }

    private void registerMBeans(boolean threadInfo) {
        MonitoringRegistrationHelper registryImpl = MonitoringRegistrationHelper.getInstance();
        Iterator iter = registryImpl.getJvmNodes(threadInfo).iterator();
        while (iter.hasNext()) {
            StatsHolder c = (StatsHolder)iter.next();
            c.registerMBean();
            logger.finer("DynamicReconfigurator: Now Registering MBean for --- " + c.getName());
        }
    }

    private void unregisterMBeans(boolean threadInfo) {
        MonitoringRegistrationHelper registryImpl = MonitoringRegistrationHelper.getInstance();
        Iterator iter = registryImpl.getJvmNodes(threadInfo).iterator();
        while (iter.hasNext()) {
            StatsHolder c = (StatsHolder)iter.next();
            c.unregisterMBean();
            logger.finer("DynamicReconfigurator: Now UnRegistering MBean for --- " + c.getName());
        }
    }

    private void registerThreadInfoMBeans() {
        MonitoringRegistrationHelper registryImpl = MonitoringRegistrationHelper.getInstance();
        Iterator iter = registryImpl.getJvmThreadInfoNodes().iterator();
        while (iter.hasNext()) {
            StatsHolder c = (StatsHolder)iter.next();
            c.registerMBean();
            logger.finer("DynamicReconfigurator: Now Registering MBean for --- " + c.getName());
        }
    }

    private void unregisterThreadInfoMBeans() {
        MonitoringRegistrationHelper registryImpl = MonitoringRegistrationHelper.getInstance();
        Iterator iter = registryImpl.getJvmThreadInfoNodes().iterator();
        while (iter.hasNext()) {
            StatsHolder c = (StatsHolder)iter.next();
            c.unregisterMBean();
            logger.finer("DynamicReconfigurator: Now UnRegistering MBean for --- " + c.getName());
        }
    }

    private boolean off2Low(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.OFF && to == MonitoringLevel.LOW;
    }

    private boolean off2High(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.OFF && to == MonitoringLevel.HIGH;
    }

    private boolean low2Off(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.LOW && to == MonitoringLevel.OFF;
    }

    private boolean high2Off(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.HIGH && to == MonitoringLevel.OFF;
    }

    private boolean low2High(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.LOW && to == MonitoringLevel.HIGH;
    }

    private boolean high2Low(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.HIGH && to == MonitoringLevel.LOW;
    }
}

