/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi;

import com.sun.enterprise.admin.monitor.registry.spi.StatsDescriptionHelper;
import com.sun.enterprise.admin.monitor.registry.spi.StatsMediator;
import com.sun.enterprise.admin.monitor.stats.JTAStats;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.management.MBeanAttributeInfo;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;

class StatsMediatorImpl
implements StatsMediator {
    private final Stats delegate;
    private final Class metaData;
    private final Map methodMap;
    private final Map firstParts;
    private final Map secondParts;
    private static final Logger logger;
    private static final StringManager sm;
    private final String DELIMITER = "-";
    private final String OLD_DELIMITER = "_";
    private Map opsMap;
    private final StatsDescriptionHelper helper = new StatsDescriptionHelper();
    private final String DESCRIPTION_GETTER = "getDescription";
    private static final String DOTTED_NAME = "dotted-name";
    static final /* synthetic */ boolean $assertionsDisabled;

    public StatsMediatorImpl(Stats delegate, Class metaData) {
        this.delegate = delegate;
        this.metaData = metaData;
        this.methodMap = new HashMap();
        this.firstParts = new HashMap();
        this.secondParts = new HashMap();
        this.reflectedAttributes();
        if (this.isJtaMetaData()) {
            this.reflectJTAOps();
        }
    }

    public Object getAttribute(String name) {
        if (!this.methodMap.containsKey(name)) {
            logger.finer("The name supplied may be an old-styled name, making one more attempt: " + name);
            name = this.getHyphenedName(name);
            if (!this.methodMap.containsKey(name)) {
                String msg = sm.getString("smi.no_such_attribute", (Object)name);
                throw new IllegalArgumentException(msg);
            }
        }
        return this.invokeGetter(name);
    }

    public MBeanAttributeInfo[] getAttributeInfos() {
        return this.attributes2Info();
    }

    public Object invoke(String method, Object[] params, String[] sign) {
        logger.fine("Invoking Method: " + method);
        Object result = null;
        if (!this.opsMap.containsKey(method)) {
            String msg = sm.getString("smi.no_such_method", (Object)method);
            throw new IllegalArgumentException(msg);
        }
        Method m = (Method)this.opsMap.get(method);
        try {
            result = m.invoke((Object)this.delegate, params);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return result;
    }

    private void reflectedAttributes() {
        if (this.metaData == null) {
            return;
        }
        Method[] methods = this.metaData.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            int index;
            String method = methods[i].getName();
            if (this.isStatsInterfaceMethod(method) || (index = method.indexOf("get")) == -1) continue;
            String baseAttrName = method.substring(index + 3);
            String[] attrSubs = this.getAttributeSubs(methods[i]);
            Method actualMethod = this.getMethodFromDelegate(method);
            this.addMapping(baseAttrName, attrSubs, actualMethod);
        }
    }

    private void reflectJTAOps() {
        this.opsMap = new HashMap();
        Method[] methods = this.metaData.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (!"freeze".equals(methodName) && !"unfreeze".equals(methodName) && !"rollback".equals(methodName)) continue;
            this.opsMap.put(methodName, methods[i]);
        }
    }

    private boolean isJtaMetaData() {
        boolean jta = false;
        if (this.metaData != null && JTAStats.class.getName().equals(this.metaData.getName())) {
            jta = true;
        }
        return jta;
    }

    private boolean isStatsInterfaceMethod(String name) {
        Method[] methods = Stats.class.getMethods();
        boolean isInterfaceMethod = false;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            isInterfaceMethod = true;
            break;
        }
        return isInterfaceMethod;
    }

    private Method getMethodFromDelegate(String methodName) {
        Method[] instanceMethods = this.delegate.getClass().getMethods();
        Method m = null;
        boolean matched = false;
        for (int i = 0; i < instanceMethods.length; ++i) {
            m = instanceMethods[i];
            if (!methodName.equals(m.getName())) continue;
            matched = true;
            break;
        }
        if (!$assertionsDisabled && !matched) {
            throw new AssertionError((Object)("The Stats object: " + this.delegate.getClass().getName() + " does not implement declared method: " + methodName));
        }
        return m;
    }

    private String[] getAttributeSubs(Method m) {
        Class<?> c = m.getReturnType();
        if (!$assertionsDisabled && !Statistic.class.isAssignableFrom(c)) {
            throw new AssertionError((Object)("The method does not return a Statistic: " + m.getName()));
        }
        Method[] rets = c.getMethods();
        String[] subs = new String[rets.length];
        for (int i = 0; i < rets.length; ++i) {
            Method am = rets[i];
            String name = am.getName();
            if (!name.startsWith("get")) continue;
            subs[i] = name.substring(3);
            logger.fine("return type = " + subs[i]);
        }
        return subs;
    }

    private void addMapping(String first, String[] lasts, Method getter) {
        for (int i = 0; i < lasts.length; ++i) {
            String lc1 = first.toLowerCase();
            String lc2 = lasts[i].toLowerCase();
            String full = lc1 + "-" + lc2;
            this.methodMap.put(full, getter);
            this.firstParts.put(lc1, first);
            this.secondParts.put(lc2, lasts[i]);
            logger.finer("Method: " + getter.getName() + " added for full attribute: " + full);
        }
    }

    private Object invokeGetter(String ab) {
        String first = ab.substring(0, ab.indexOf("-"));
        first = (String)this.firstParts.get(first);
        String fName = "get" + first;
        String last = ab.substring(ab.indexOf("-") + 1);
        last = (String)this.secondParts.get(last);
        String lName = "get" + last;
        if (lName.equalsIgnoreCase("getDescription")) {
            return this.getDescription(first);
        }
        Method lastMethod = null;
        try {
            Method firstMethod = (Method)this.methodMap.get(ab);
            Object firstResult = firstMethod.invoke((Object)this.delegate, null);
            lastMethod = firstResult.getClass().getMethod(lName, null);
            Object value = lastMethod.invoke(firstResult, null);
            logger.finer("Got value for: " + ab + " as: " + value + " class = " + value.getClass().getName());
            return value;
        }
        catch (Exception e) {
            logger.throwing(StatsMediatorImpl.class.getName(), "invokeGetter", e);
            throw new RuntimeException(e);
        }
    }

    private MBeanAttributeInfo[] attributes2Info() {
        Iterator it = this.methodMap.keySet().iterator();
        ArrayList<MBeanAttributeInfo> attrInfo = new ArrayList<MBeanAttributeInfo>();
        boolean i = false;
        while (it.hasNext()) {
            String name = (String)it.next();
            String type = this.getType(name);
            String desc = this.getDescription(name);
            boolean isReadable = this.getReadable(name);
            boolean isWritable = false;
            boolean isIs = false;
            attrInfo.add(new MBeanAttributeInfo(name, type, desc, isReadable, false, false));
            logger.finer("Added the attribute to MBeanAttributeInfo: " + name);
        }
        MBeanAttributeInfo dottedNameInfo = new MBeanAttributeInfo(DOTTED_NAME, this.getType(DOTTED_NAME), this.getDescription(DOTTED_NAME), true, false, false);
        attrInfo.add(dottedNameInfo);
        MBeanAttributeInfo[] ais = new MBeanAttributeInfo[attrInfo.size()];
        logger.finer("No of attrs = " + attrInfo.size());
        return attrInfo.toArray(ais);
    }

    private String getDescription(String name) {
        return this.helper.getDescription(name);
    }

    private String getType(String name) {
        return "java.lang.String";
    }

    private boolean getReadable(String name) {
        return true;
    }

    private String getHyphenedName(String name) {
        return name.toLowerCase().replace("_".charAt(0), "-".charAt(0));
    }

    static {
        $assertionsDisabled = !StatsMediatorImpl.class.desiredAssertionStatus();
        logger = Logger.getLogger("javax.enterprise.system.tools.admin");
        sm = StringManager.getManager((Class)StatsMediatorImpl.class);
    }
}

