/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi;

import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.StatsHolder;
import com.sun.enterprise.admin.monitor.registry.spi.DottedNameFactory;
import com.sun.enterprise.admin.monitor.registry.spi.MonitoringObjectNames;
import com.sun.enterprise.admin.monitor.registry.spi.MonitoringRegistrationHelper;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.MonitoringConfigurationHandler;
import com.sun.enterprise.admin.monitor.stats.JVMClassLoadingStats;
import com.sun.enterprise.admin.monitor.stats.JVMCompilationStats;
import com.sun.enterprise.admin.monitor.stats.JVMMemoryStats;
import com.sun.enterprise.admin.monitor.stats.JVMOperatingSystemStats;
import com.sun.enterprise.admin.monitor.stats.JVMRuntimeStats;
import com.sun.enterprise.admin.monitor.stats.JVMThreadStats;
import com.sun.enterprise.admin.monitor.stats.spi.JVMClassLoadingStatsImpl;
import com.sun.enterprise.admin.monitor.stats.spi.JVMCompilationStatsImpl;
import com.sun.enterprise.admin.monitor.stats.spi.JVMGarbageCollectorStatsImpl;
import com.sun.enterprise.admin.monitor.stats.spi.JVMMemoryStatsImpl;
import com.sun.enterprise.admin.monitor.stats.spi.JVMOperatingSystemStatsImpl;
import com.sun.enterprise.admin.monitor.stats.spi.JVMRuntimeStatsImpl;
import com.sun.enterprise.admin.monitor.stats.spi.JVMThreadInfoStatsImpl;
import com.sun.enterprise.admin.monitor.stats.spi.JVMThreadStatsImpl;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.Stats;

public class JVMMonitoringManager
implements MonitoringLevelListener {
    private static final Logger logger;
    private static final JVMMonitoringManager jmm;
    private final int STACK_DEPTH = 5;
    private final String THREAD_NODE_NAME = "thread";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$enterprise$admin$monitor$stats$JVMGarbageCollectorStats;
    static /* synthetic */ Class class$com$sun$enterprise$admin$monitor$stats$JVMThreadInfoStats;

    private JVMMonitoringManager() {
    }

    public static JVMMonitoringManager getInstance() {
        return jmm;
    }

    public void registerStats(StatsHolder rootNode) {
        MonitoringLevel level = MonitoringConfigurationHandler.getLevel(MonitoredObjectType.JVM);
        if (level != MonitoringLevel.OFF) {
            try {
                this.registerJVMCompilationStats(rootNode);
                this.registerJVMClassLoadingStats(rootNode);
                this.registerJVMRuntimeStats(rootNode);
                this.registerJVMOperatingSystemStats(rootNode);
                this.registerJVMGarbageCollectorStats(rootNode);
                this.registerJVMMemoryStats(rootNode);
                this.registerJVMThreadStats(rootNode);
                if (level == MonitoringLevel.HIGH) {
                    this.registerJVMThreadInfoStats(rootNode);
                }
            }
            catch (MonitoringRegistrationException mre) {
                logger.finest("MonitoringRegistrationException in the registration of JVM1.5 Stats: " + mre.getLocalizedMessage());
            }
            catch (Exception e) {
                logger.finest("Exception in the registration of JVM 1.5 Stats: " + e.getLocalizedMessage());
            }
        }
    }

    public void registerJVMCompilationStats(StatsHolder rootNode) throws MonitoringRegistrationException {
        StatsHolder jvmNode = rootNode.getChild(MonitoredObjectType.JVM.getTypeName());
        if (!$assertionsDisabled && jvmNode == null) {
            throw new AssertionError((Object)"jvm node is null");
        }
        StatsHolder childNode = jvmNode.addChild(MonitoredObjectType.JVM_COMPILATION.getTypeName(), MonitoredObjectType.JVM_COMPILATION);
        childNode.setStats(new JVMCompilationStatsImpl());
        childNode.setStatsClass(JVMCompilationStats.class);
        childNode.setDottedName(DottedNameFactory.getJVMCompilationDottedName());
        childNode.setObjectName(MonitoringObjectNames.getJVMCompilationObjectName());
        childNode.registerMBean();
    }

    public void registerJVMClassLoadingStats(StatsHolder rootNode) throws MonitoringRegistrationException {
        StatsHolder jvmNode = rootNode.getChild(MonitoredObjectType.JVM.getTypeName());
        if (!$assertionsDisabled && jvmNode == null) {
            throw new AssertionError((Object)"jvm node is null");
        }
        StatsHolder childNode = jvmNode.addChild(MonitoredObjectType.JVM_CLASSLOADING.getTypeName(), MonitoredObjectType.JVM_CLASSLOADING);
        childNode.setStats(new JVMClassLoadingStatsImpl());
        childNode.setStatsClass(JVMClassLoadingStats.class);
        childNode.setDottedName(DottedNameFactory.getJVMClassLoadingDottedName());
        childNode.setObjectName(MonitoringObjectNames.getJVMClassLoadingObjectName());
        childNode.registerMBean();
    }

    public void registerJVMRuntimeStats(StatsHolder rootNode) throws MonitoringRegistrationException {
        StatsHolder jvmNode = rootNode.getChild(MonitoredObjectType.JVM.getTypeName());
        if (!$assertionsDisabled && jvmNode == null) {
            throw new AssertionError((Object)"jvm node is null");
        }
        StatsHolder childNode = jvmNode.addChild(MonitoredObjectType.JVM_RUNTIME.getTypeName(), MonitoredObjectType.JVM_RUNTIME);
        childNode.setStats(new JVMRuntimeStatsImpl());
        childNode.setStatsClass(JVMRuntimeStats.class);
        childNode.setDottedName(DottedNameFactory.getJVMRuntimeDottedName());
        childNode.setObjectName(MonitoringObjectNames.getJVMRuntimeObjectName());
        childNode.registerMBean();
    }

    public void registerJVMOperatingSystemStats(StatsHolder rootNode) throws MonitoringRegistrationException {
        StatsHolder jvmNode = rootNode.getChild(MonitoredObjectType.JVM.getTypeName());
        if (!$assertionsDisabled && jvmNode == null) {
            throw new AssertionError((Object)"jvm node is null");
        }
        StatsHolder childNode = jvmNode.addChild(MonitoredObjectType.JVM_OS.getTypeName(), MonitoredObjectType.JVM_OS);
        childNode.setStats(new JVMOperatingSystemStatsImpl());
        childNode.setStatsClass(JVMOperatingSystemStats.class);
        childNode.setDottedName(DottedNameFactory.getJVMOSDottedName());
        childNode.setObjectName(MonitoringObjectNames.getJVMOSObjectName());
        childNode.registerMBean();
    }

    public void unregisterStats(StatsHolder rootNode, boolean includeThreadInfo) throws MonitoringRegistrationException {
        StatsHolder jvmNode = rootNode.getChild(MonitoredObjectType.JVM.getTypeName());
        if (!$assertionsDisabled && jvmNode == null) {
            throw new AssertionError((Object)"jvm node is null");
        }
        ArrayList c = new ArrayList();
        c.addAll(jvmNode.getAllChildren());
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            StatsHolder s;
            Iterator it;
            ArrayList c1;
            StatsHolder childNode = (StatsHolder)iter.next();
            if (childNode.getType() == MonitoredObjectType.JVM_GCS) {
                c1 = new ArrayList();
                c1.addAll(childNode.getAllChildren());
                it = c1.iterator();
                while (it.hasNext()) {
                    s = (StatsHolder)it.next();
                    s.unregisterMBean();
                    childNode.removeChild(s.getName());
                }
            }
            if (childNode.getType() == MonitoredObjectType.JVM_THREAD && includeThreadInfo) {
                c1 = new ArrayList();
                c1.addAll(childNode.getAllChildren());
                it = c1.iterator();
                while (it.hasNext()) {
                    s = (StatsHolder)it.next();
                    s.unregisterMBean();
                    childNode.removeChild(s.getName());
                }
            }
            childNode.unregisterMBean();
            jvmNode.removeChild(childNode.getName());
        }
    }

    public void registerJVMGarbageCollectorStats(StatsHolder rootNode) throws MonitoringRegistrationException {
        StatsHolder jvmNode = rootNode.getChild(MonitoredObjectType.JVM.getTypeName());
        if (!$assertionsDisabled && jvmNode == null) {
            throw new AssertionError((Object)"jvm node is null");
        }
        StatsHolder gcsNode = jvmNode.addChild(MonitoredObjectType.JVM_GCS.getTypeName(), MonitoredObjectType.JVM_GCS);
        gcsNode.setDottedName(DottedNameFactory.getJVMGCSDottedName());
        gcsNode.setObjectName(MonitoringObjectNames.getJVMGCSSObjectName());
        gcsNode.registerMBean();
        List<GarbageCollectorMXBean> beanList = ManagementFactory.getGarbageCollectorMXBeans();
        Iterator<GarbageCollectorMXBean> iter = beanList.iterator();
        while (iter.hasNext()) {
            GarbageCollectorMXBean bean = iter.next();
            StatsHolder gcNode = gcsNode.addChild(bean.getName(), MonitoredObjectType.JVM_GC);
            gcNode.setStats(new JVMGarbageCollectorStatsImpl(bean));
            gcNode.setStatsClass(class$com$sun$enterprise$admin$monitor$stats$JVMGarbageCollectorStats == null ? JVMMonitoringManager.class$("com.sun.enterprise.admin.monitor.stats.JVMGarbageCollectorStats") : class$com$sun$enterprise$admin$monitor$stats$JVMGarbageCollectorStats);
            gcNode.setDottedName(DottedNameFactory.getJVMGCDottedName(bean.getName()));
            gcNode.setObjectName(MonitoringObjectNames.getJVMGCObjectName(bean.getName()));
            gcNode.registerMBean();
        }
    }

    public void registerJVMMemoryStats(StatsHolder rootNode) throws MonitoringRegistrationException {
        StatsHolder jvmNode = rootNode.getChild(MonitoredObjectType.JVM.getTypeName());
        if (!$assertionsDisabled && jvmNode == null) {
            throw new AssertionError((Object)"jvm node is null");
        }
        StatsHolder childNode = jvmNode.addChild(MonitoredObjectType.JVM_MEMORY.getTypeName(), MonitoredObjectType.JVM_MEMORY);
        childNode.setStats(new JVMMemoryStatsImpl());
        childNode.setStatsClass(JVMMemoryStats.class);
        childNode.setDottedName(DottedNameFactory.getJVMMemoryDottedName());
        childNode.setObjectName(MonitoringObjectNames.getJVMMemoryObjectName());
        childNode.registerMBean();
    }

    public void registerJVMThreadStats(StatsHolder rootNode) throws MonitoringRegistrationException {
        StatsHolder jvmNode = rootNode.getChild(MonitoredObjectType.JVM.getTypeName());
        if (!$assertionsDisabled && jvmNode == null) {
            throw new AssertionError((Object)"jvm node is null");
        }
        StatsHolder childNode = jvmNode.addChild(MonitoredObjectType.JVM_THREAD.getTypeName(), MonitoredObjectType.JVM_THREAD);
        childNode.setStats(new JVMThreadStatsImpl());
        childNode.setStatsClass(JVMThreadStats.class);
        childNode.setDottedName(DottedNameFactory.getJVMThreadDottedName());
        childNode.setObjectName(MonitoringObjectNames.getJVMThreadObjectName());
        childNode.registerMBean();
    }

    public void registerJVMThreadInfoStats(StatsHolder rootNode) throws MonitoringRegistrationException {
        StatsHolder jvmNode = rootNode.getChild(MonitoredObjectType.JVM.getTypeName());
        if (!$assertionsDisabled && jvmNode == null) {
            throw new AssertionError((Object)"jvm node is null");
        }
        StatsHolder threadSystemNode = jvmNode.getChild(MonitoredObjectType.JVM_THREAD.getTypeName());
        if (!$assertionsDisabled && threadSystemNode == null) {
            throw new AssertionError((Object)"thread-system node is null");
        }
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long[] ids = bean.getAllThreadIds();
        for (int i = 0; i < ids.length; ++i) {
            ThreadInfo info = bean.getThreadInfo(ids[i], 5);
            String threadName = "thread-" + ids[i];
            StatsHolder childNode = threadSystemNode.addChild(threadName, MonitoredObjectType.JVM_THREAD_INFO);
            childNode.setStats(new JVMThreadInfoStatsImpl(info));
            childNode.setStatsClass(class$com$sun$enterprise$admin$monitor$stats$JVMThreadInfoStats == null ? JVMMonitoringManager.class$("com.sun.enterprise.admin.monitor.stats.JVMThreadInfoStats") : class$com$sun$enterprise$admin$monitor$stats$JVMThreadInfoStats);
            childNode.setDottedName(DottedNameFactory.getJVMThreadInfoDottedName(threadName));
            childNode.setObjectName(MonitoringObjectNames.getJVMThreadInfoObjectName(threadName));
            childNode.registerMBean();
        }
    }

    public void unregisterJVMThreadInfoStats(StatsHolder rootNode) throws MonitoringRegistrationException {
        StatsHolder jvmNode = rootNode.getChild(MonitoredObjectType.JVM.getTypeName());
        if (!$assertionsDisabled && jvmNode == null) {
            throw new AssertionError((Object)"jvm node is null");
        }
        StatsHolder threadSystemNode = jvmNode.getChild(MonitoredObjectType.JVM_THREAD.getTypeName());
        if (!$assertionsDisabled && threadSystemNode == null) {
            throw new AssertionError((Object)"thread-system node is null");
        }
        ArrayList c = new ArrayList();
        c.addAll(threadSystemNode.getAllChildren());
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            StatsHolder s = (StatsHolder)iter.next();
            s.unregisterMBean();
            threadSystemNode.removeChild(s.getName());
        }
    }

    private void registerAllStats(StatsHolder rootNode, boolean includeThreadInfo) {
        try {
            this.registerJVMCompilationStats(rootNode);
            this.registerJVMClassLoadingStats(rootNode);
            this.registerJVMRuntimeStats(rootNode);
            this.registerJVMOperatingSystemStats(rootNode);
            this.registerJVMGarbageCollectorStats(rootNode);
            this.registerJVMMemoryStats(rootNode);
            this.registerJVMThreadStats(rootNode);
            if (includeThreadInfo) {
                this.registerJVMThreadInfoStats(rootNode);
            }
        }
        catch (MonitoringRegistrationException mre) {
            logger.finest("MonitoringRegistrationException in the registration of JVM1.5 Stats: " + mre.getLocalizedMessage());
        }
        catch (Exception e) {
            logger.finest("Exception in the registration of JVM 1.5 Stats: " + e.getLocalizedMessage());
        }
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType type) {
        logger.finest("changeLevel being invoked on the JVM");
        MonitoringRegistrationHelper registryImpl = MonitoringRegistrationHelper.getInstance();
        StatsHolder root = registryImpl.getRootStatsHolder();
        boolean includeThreadInfo = false;
        if (to == MonitoringLevel.OFF) {
            if (from == MonitoringLevel.HIGH) {
                includeThreadInfo = true;
            }
            try {
                this.unregisterStats(root, includeThreadInfo);
            }
            catch (MonitoringRegistrationException mre) {
                logger.finest("MonitoringRegistrationException in the unregistration of JVM 1.5 Stats: " + mre.getLocalizedMessage());
            }
            catch (Exception e) {
                logger.finest("Exception in the unregistration of JVM 1.5 Stats: " + e.getLocalizedMessage());
            }
        }
        if (from == MonitoringLevel.OFF) {
            if (to == MonitoringLevel.HIGH) {
                includeThreadInfo = true;
            }
            this.registerAllStats(root, includeThreadInfo);
        }
        if (from == MonitoringLevel.LOW && to == MonitoringLevel.HIGH) {
            try {
                this.registerJVMThreadInfoStats(root);
            }
            catch (MonitoringRegistrationException mre) {
                logger.finest("MonitoringRegistrationException in the registration of JVM ThreadInfoStats: " + mre.getLocalizedMessage());
            }
            catch (Exception e) {
                logger.finest("Exception in the registration of JVM ThreadInfo Stats: " + e.getLocalizedMessage());
            }
        }
        if (from == MonitoringLevel.HIGH && to == MonitoringLevel.LOW) {
            try {
                this.unregisterJVMThreadInfoStats(root);
            }
            catch (MonitoringRegistrationException mre) {
                logger.finest("MonitoringRegistrationException in the unregistration of JVM ThreadInfoStats: " + mre.getLocalizedMessage());
            }
            catch (Exception e) {
                logger.finest("Exception in the unregistration of JVM ThreadInfo Stats: " + e.getLocalizedMessage());
            }
        }
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, Stats handback) {
    }

    public void setLevel(MonitoringLevel level) {
    }

    static {
        $assertionsDisabled = !JVMMonitoringManager.class.desiredAssertionStatus();
        logger = Logger.getLogger("javax.enterprise.system.tools.admin");
        jmm = new JVMMonitoringManager();
    }
}

