/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor;

import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.HashMap;

public class MonitoredObjectType {
    private static final HashMap objectMap = new HashMap();
    public static final MonitoredObjectType ROOT = new MonitoredObjectType("root", true);
    public static final MonitoredObjectType APPLICATION = new MonitoredObjectType("application");
    public static final MonitoredObjectType EJBMODULE = new MonitoredObjectType("ejb-module");
    public static final MonitoredObjectType STANDALONE_EJBMODULE = new MonitoredObjectType("standalone-ejb-module");
    public static final MonitoredObjectType WEBMODULE = new MonitoredObjectType("web-module");
    public static final MonitoredObjectType STANDALONE_WEBMODULE = new MonitoredObjectType("standalone-web-module");
    public static final MonitoredObjectType STATELESS_BEAN = new MonitoredObjectType("stateless-session-bean");
    public static final MonitoredObjectType STATEFUL_BEAN = new MonitoredObjectType("stateful-session-bean");
    public static final MonitoredObjectType ENTITY_BEAN = new MonitoredObjectType("entity-bean");
    public static final MonitoredObjectType MESSAGE_DRIVEN_BEAN = new MonitoredObjectType("message-driven-bean");
    public static final MonitoredObjectType BEAN_POOL = new MonitoredObjectType("bean-pool", true);
    public static final MonitoredObjectType BEAN_CACHE = new MonitoredObjectType("bean-cache", true);
    public static final MonitoredObjectType BEAN_METHOD = new MonitoredObjectType("bean-method");
    public static final MonitoredObjectType HTTP_SERVER = new MonitoredObjectType("http-server", true);
    public static final MonitoredObjectType VIRTUAL_SERVER = new MonitoredObjectType("virtual-server", true);
    public static final MonitoredObjectType PROCESS = new MonitoredObjectType("process", true);
    public static final MonitoredObjectType TXNMGR = new MonitoredObjectType("transaction-service", true);
    public static final MonitoredObjectType IIOP_SERVICE = new MonitoredObjectType("iiop-service", true);
    public static final MonitoredObjectType ORB = new MonitoredObjectType("orb");
    public static final MonitoredObjectType ORB_CONNECTION = new MonitoredObjectType("orb-connection", true);
    public static final MonitoredObjectType ORB_THREAD_POOL = new MonitoredObjectType("orb-thread-pool", true);
    public static final MonitoredObjectType RESOURCES = new MonitoredObjectType("resources", true);
    public static final MonitoredObjectType JDBC_CONN_POOL = new MonitoredObjectType("jdbc-connection-pool", false);
    private String typeName;
    private boolean isSingleton;
    private int enableCount = 0;
    public static final MonitoredObjectType[] EJB_TYPES = new MonitoredObjectType[]{ROOT, APPLICATION, EJBMODULE, STANDALONE_EJBMODULE, STATELESS_BEAN, STATEFUL_BEAN, ENTITY_BEAN, BEAN_POOL, BEAN_CACHE, BEAN_METHOD};
    public static final MonitoredObjectType[] MDB_TYPES = new MonitoredObjectType[]{ROOT, APPLICATION, EJBMODULE, STANDALONE_EJBMODULE, MESSAGE_DRIVEN_BEAN, BEAN_POOL, BEAN_CACHE, BEAN_METHOD};
    public static final MonitoredObjectType[] ORB_TYPES = new MonitoredObjectType[]{ROOT, IIOP_SERVICE, ORB, ORB_CONNECTION, ORB_THREAD_POOL};
    public static final MonitoredObjectType[] JTS_TYPES = new MonitoredObjectType[]{ROOT, TXNMGR};
    private static boolean ejbMonitoringEnabled = false;
    private static boolean mdbMonitoringEnabled = false;
    private static boolean orbMonitoringEnabled = false;
    private static boolean jtsMonitoringEnabled = false;
    private static StringManager localStrings = StringManager.getManager((Class)MonitoredObjectType.class);

    private MonitoredObjectType(String type) {
        this(type, false);
    }

    private MonitoredObjectType(String type, boolean isSingleton) {
        this.typeName = type;
        this.isSingleton = isSingleton;
        objectMap.put(this.typeName, this);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public String toString() {
        return this.typeName;
    }

    public boolean isMonitoringEnabled() {
        return this.enableCount > 0;
    }

    public static MonitoredObjectType getMonitoredObjectType(String typeName) {
        MonitoredObjectType type = MonitoredObjectType.getMonitoredObjectTypeOrNull(typeName);
        if (type == null) {
            String msg = localStrings.getString("admin.monitor.unknown_type_name", (Object)typeName);
            throw new IllegalArgumentException(msg);
        }
        return type;
    }

    static MonitoredObjectType getMonitoredObjectTypeOrNull(String typeName) {
        MonitoredObjectType type = null;
        if (objectMap != null && typeName != null) {
            type = (MonitoredObjectType)objectMap.get(typeName);
        }
        return type;
    }

    private static synchronized void enableTypes(MonitoredObjectType[] types) {
        int size = types.length;
        for (int i = 0; i < size; ++i) {
            ++types[i].enableCount;
        }
    }

    private static synchronized void disableTypes(MonitoredObjectType[] types) {
        int size = types.length;
        for (int i = 0; i < size; ++i) {
            if (types[i].enableCount > 0) {
                --types[i].enableCount;
                continue;
            }
            String msg = localStrings.getString("admin.monitor.monitored_object_type_already_disabled", (Object)types[i].toString());
            throw new IllegalStateException(msg);
        }
    }

    public static void setEjbMonitoringEnabled(boolean enable) {
        ejbMonitoringEnabled = MonitoredObjectType.setMonitoringEnabled(EJB_TYPES, ejbMonitoringEnabled, enable);
    }

    public static void setMdbMonitoringEnabled(boolean enable) {
        mdbMonitoringEnabled = MonitoredObjectType.setMonitoringEnabled(MDB_TYPES, mdbMonitoringEnabled, enable);
    }

    public static void setOrbMonitoringEnabled(boolean enable) {
        orbMonitoringEnabled = MonitoredObjectType.setMonitoringEnabled(ORB_TYPES, orbMonitoringEnabled, enable);
    }

    public static void setJtsMonitoringEnabled(boolean enable) {
        jtsMonitoringEnabled = MonitoredObjectType.setMonitoringEnabled(JTS_TYPES, jtsMonitoringEnabled, enable);
    }

    static void setMonitoringEnabled(String comp, boolean enable) {
        if (ServerTags.EJB_CONTAINER.equals(comp)) {
            MonitoredObjectType.setEjbMonitoringEnabled(enable);
        } else if (ServerTags.MDB_CONTAINER.equals(comp)) {
            MonitoredObjectType.setMdbMonitoringEnabled(enable);
        } else if (ServerTags.ORB.equals(comp)) {
            MonitoredObjectType.setOrbMonitoringEnabled(enable);
        } else if (ServerTags.TRANSACTION_SERVICE.equals(comp)) {
            MonitoredObjectType.setJtsMonitoringEnabled(enable);
        }
    }

    private static boolean setMonitoringEnabled(MonitoredObjectType[] types, boolean oldEnabled, boolean newEnabled) {
        if (newEnabled != oldEnabled) {
            oldEnabled = newEnabled;
            if (oldEnabled) {
                MonitoredObjectType.enableTypes(types);
            } else {
                MonitoredObjectType.disableTypes(types);
            }
        }
        return newEnabled;
    }
}

