/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.server;

import com.sun.enterprise.util.i18n.StringManager;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.logging.Logger;

class RmiStubRegistryHandler {
    private static StringManager sm = StringManager.getManager((Class)RmiStubRegistryHandler.class);
    private final Logger logger;

    RmiStubRegistryHandler(int port, boolean secureRegistry, Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("Internal: Null logger");
        }
        this.logger = logger;
        if (secureRegistry) {
            throw new UnsupportedOperationException("Yet to be implemented");
        }
        this.startInsecureRegistry(port);
    }

    private void startInsecureRegistry(int port) {
        try {
            Registry r = LocateRegistry.createRegistry(port);
            this.logBindings(r, port);
        }
        catch (Exception e) {
            String msg = sm.getString("no.port.msg", (Object)new Integer(port));
            throw new RuntimeException(e);
        }
    }

    private void logBindings(Registry r, int port) {
        try {
            String[] bs = r.list();
            this.logger.fine("Initial Bindings in RmiRegistry at port: [" + port + "] :");
            for (int i = 0; i < bs.length; ++i) {
                this.logger.fine("JMX Connector RMI Registry binding: " + bs[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

