/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.comm;

import com.sun.enterprise.admin.jmx.remote.comm.AuthenticationInfo;
import com.sun.enterprise.admin.jmx.remote.comm.GenericHttpConnectorAddress;
import com.sun.enterprise.admin.jmx.remote.comm.HostAndPort;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import sun.misc.BASE64Encoder;

public final class HttpConnectorAddress
implements GenericHttpConnectorAddress {
    private static final String HTTP_CONNECTOR = "http";
    private static final String HTTPS_CONNECTOR = "https";
    private static final String AUTHORIZATION_KEY = "Authorization";
    private static final String AUTHORIZATION_TYPE = "Basic ";
    private String host;
    private int port;
    private AuthenticationInfo authInfo;
    private boolean secure;

    public HttpConnectorAddress() {
    }

    public HttpConnectorAddress(HostAndPort h) {
        this(h.getHost(), h.getPort(), h.isSecure());
    }

    public HttpConnectorAddress(String host, int port) {
        this(host, port, false);
    }

    public HttpConnectorAddress(String host, int port, boolean secure) {
        this.host = host;
        this.port = port;
        this.secure = secure;
    }

    public URLConnection openConnection(String path) throws IOException {
        return this.openConnection(this.toURL(path));
    }

    public String getConnectorType() {
        return this.isSecure() ? HTTPS_CONNECTOR : HTTP_CONNECTOR;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authInfo;
    }

    public void setAuthenticationInfo(AuthenticationInfo authInfo) {
        this.authInfo = authInfo;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    private final String getUser() {
        return this.authInfo != null ? this.authInfo.getUser() : "";
    }

    private final String getPassword() {
        return this.authInfo != null ? this.authInfo.getPassword() : "";
    }

    private final String asURLSpec(String path) {
        return this.getConnectorType() + "://" + this.getAuthority() + (path != null ? path : "");
    }

    private final String getAuthority() {
        return this.getHost() + ":" + this.getPort();
    }

    private final URL toURL(String path) throws MalformedURLException {
        return new URL(this.asURLSpec(path));
    }

    private final URLConnection openConnection(URL url) throws IOException {
        return this.setOptions(this.makeConnection(url));
    }

    private final URLConnection makeConnection(URL url) throws IOException {
        return url.openConnection();
    }

    private final URLConnection setOptions(URLConnection uc) {
        uc.setDoOutput(true);
        uc.setUseCaches(false);
        uc.setRequestProperty("Content-type", "application/octet-stream");
        uc.setRequestProperty("Connection", "Keep-Alive");
        return this.setAuthentication(uc);
    }

    private final URLConnection setAuthentication(URLConnection uc) {
        if (this.authInfo != null) {
            uc.setRequestProperty(AUTHORIZATION_KEY, this.getBasicAuthString());
        }
        return uc;
    }

    private final String getBasicAuthString() {
        String enc = HttpConnectorAddress.getBase64Encoded(this.getUser() + ":" + this.getPassword());
        enc = enc.replaceAll(System.getProperty("line.separator"), "");
        return AUTHORIZATION_TYPE + enc;
    }

    private static final String getBase64Encoded(String clearString) {
        return new BASE64Encoder().encode(clearString.getBytes());
    }
}

