/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote;

import com.sun.enterprise.admin.jmx.remote.comm.AuthenticationInfo;
import com.sun.enterprise.admin.jmx.remote.comm.HttpConnectorAddress;
import com.sun.enterprise.admin.jmx.remote.internal.RemoteMBeanServerConnection;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXServiceURL;

final class MBeanServerConnectionFactory {
    private MBeanServerConnectionFactory() {
    }

    static MBeanServerConnection getRemoteMBeanServerConnection(Map env, JMXServiceURL serviceUrl) throws Exception {
        return new RemoteMBeanServerConnection(MBeanServerConnectionFactory.env2HttpAddress(env, serviceUrl));
    }

    private static HttpConnectorAddress env2HttpAddress(Map env, JMXServiceURL serviceUrl) {
        HttpConnectorAddress ad = new HttpConnectorAddress(serviceUrl.getHost(), serviceUrl.getPort(), MBeanServerConnectionFactory.isHttps(serviceUrl));
        ad.setAuthenticationInfo(MBeanServerConnectionFactory.env2AuthenticationInfo(env));
        return ad;
    }

    private static AuthenticationInfo env2AuthenticationInfo(Map env) {
        String user = (String)env.get("USER");
        String pwd = (String)env.get("PASSWORD");
        return new AuthenticationInfo(user, pwd);
    }

    private static boolean isHttps(JMXServiceURL url) {
        return "s1ashttps".equals(url.getProtocol());
    }
}

