/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class PasswordConfReader {
    public static final String KEY_STORE_ALIAS = "KeyStore";
    public static final String TRUST_STORE_ALIAS = "TrustStore";
    public static final String PASSWORD_FILE_PROPERTY = "com.sun.aas.ssl.passwordfile";
    static final String CONFIG = "config";
    static final String PASSWORD_CONF = "password.conf";
    private static final String INSTANCE_ROOT = System.getProperty("com.sun.aas.instanceRoot");
    private static final String SERVER_NAME_PROPERTY = "com.sun.aas.instanceName";
    private static PasswordFile pf;
    private static Hashtable entries;

    private PasswordConfReader() {
    }

    public static String getKeyStorePassword() throws IOException {
        return PasswordConfReader.getPassword(KEY_STORE_ALIAS);
    }

    public static String getTrustStorePassword() throws IOException {
        return PasswordConfReader.getPassword(TRUST_STORE_ALIAS);
    }

    public static String getPassword(String alias) throws IOException {
        if (!PasswordConfReader.isInSync()) {
            PasswordConfReader.sync();
        }
        return PasswordConfReader.get(alias);
    }

    public static Enumeration listAliases() throws IOException {
        if (!PasswordConfReader.isInSync()) {
            PasswordConfReader.sync();
        }
        return entries.keys();
    }

    private static boolean isInSync() throws IOException {
        return PasswordConfReader.getPasswordFile().equals(pf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sync() throws IOException {
        Class clazz = PasswordConfReader.class;
        synchronized (clazz) {
            pf = PasswordConfReader.getPasswordFile();
        }
        PasswordConfReader.loadEntries();
    }

    private static PasswordFile getPasswordFile() throws IOException {
        String prop = System.getProperty(PASSWORD_FILE_PROPERTY);
        PasswordFile f = prop != null && prop.length() > 0 ? new PasswordFile(prop) : new PasswordFile(PasswordConfReader.getDefaultPasswordConf());
        return f;
    }

    private static String getDefaultPasswordConf() {
        String defaultConf = null;
        if (INSTANCE_ROOT != null) {
            defaultConf = INSTANCE_ROOT + File.separator + File.separator + CONFIG + File.separator + PASSWORD_CONF;
        }
        return defaultConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadEntries() throws IOException {
        if (entries == null) {
            entries = new Hashtable();
        }
        BufferedReader reader = null;
        try {
            String str;
            reader = new BufferedReader(new FileReader(pf.getPath()));
            while ((str = reader.readLine()) != null) {
                int index = str.indexOf(58);
                if (index <= 0) continue;
                entries.put(str.substring(0, index), str.substring(index + 1));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static synchronized String get(String key) throws IOException {
        String password = (String)entries.get(key);
        if (password == null) {
            throw new IOException("No entry found for " + key);
        }
        return password;
    }

    private static final class PasswordFile {
        private String path;
        private long lastModified;

        private PasswordFile(String path) throws IOException {
            File f = new File(path).getCanonicalFile();
            if (!f.exists()) {
                throw new IOException("Password file does not exist. " + f.getAbsolutePath());
            }
            this.path = f.getAbsolutePath();
            this.lastModified = f.lastModified();
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            PasswordFile that = (PasswordFile)o;
            return this.path.equals(that.path) && this.lastModified == that.lastModified;
        }

        public String toString() {
            return "Path = " + this.getPath() + ' ' + "lastModified = " + this.lastModified;
        }
    }
}

