/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.stringifier;

import com.sun.appserv.management.util.misc.ArrayConversion;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.stringifier.ArrayStringifier;
import com.sun.appserv.management.util.stringifier.InterfacesStringifier;
import com.sun.appserv.management.util.stringifier.Stringifier;
import com.sun.appserv.management.util.stringifier.StringifierRegistry;
import com.sun.appserv.management.util.stringifier.StringifierRegistryImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public final class SmartStringifier
implements Stringifier {
    public static SmartStringifier DEFAULT = new SmartStringifier(",");
    private final String mMultiDelim;
    private final boolean mEncloseArrays;
    protected StringifierRegistry mRegistry;
    private static final Class[] STRINGIFIER_REGISTRY_LOOKUPS = new Class[]{Iterator.class, Collection.class, HashMap.class};
    static /* synthetic */ Class class$java$lang$Object;

    public SmartStringifier() {
        this(",");
    }

    public SmartStringifier(String multiDelim) {
        this(multiDelim, true);
    }

    public SmartStringifier(String multiDelim, boolean encloseArrays) {
        this(StringifierRegistryImpl.DEFAULT, multiDelim, encloseArrays);
    }

    public SmartStringifier(StringifierRegistry registry, String multiDelim, boolean encloseArrays) {
        this.mMultiDelim = multiDelim;
        this.mEncloseArrays = encloseArrays;
        this.mRegistry = registry;
    }

    public void setRegistry(StringifierRegistry registry) {
        this.mRegistry = registry;
    }

    private Stringifier getStringifier(Object target) {
        Class[] interfaces;
        if (target == null) {
            return null;
        }
        Class<?> targetClass = target.getClass();
        Stringifier stringifier = this.mRegistry.lookup(targetClass);
        if (stringifier == null) {
            Class theClass;
            int numLookups = STRINGIFIER_REGISTRY_LOOKUPS.length;
            for (int i = 0; !(i >= numLookups || (stringifier = this.mRegistry.lookup(theClass = STRINGIFIER_REGISTRY_LOOKUPS[i])) != null && theClass.isAssignableFrom(target.getClass())); ++i) {
            }
        }
        if (stringifier == null) {
            for (Class<?> tempClass = targetClass; tempClass != (class$java$lang$Object == null ? SmartStringifier.class$("java.lang.Object") : class$java$lang$Object) && (stringifier = this.mRegistry.lookup(tempClass)) == null; tempClass = tempClass.getSuperclass()) {
            }
        }
        if (stringifier == null && (interfaces = targetClass.getInterfaces()).length != 0) {
            stringifier = new InterfacesStringifier(interfaces);
        }
        return stringifier;
    }

    private String smartStringify(Object target) {
        String result = null;
        if (ClassUtil.objectIsArray(target)) {
            Object[] theArray = null;
            Class elementClass = ClassUtil.getArrayElementClass(target.getClass());
            theArray = ClassUtil.IsPrimitiveClass(elementClass) ? ArrayConversion.toAppropriateType(target) : (Object[])target;
            result = ArrayStringifier.stringify(theArray, this.mMultiDelim, this);
            if (this.mEncloseArrays) {
                result = "{" + result + "}";
            }
        } else {
            Stringifier stringifier = this.getStringifier(target);
            if (stringifier != null && stringifier.getClass() == this.getClass()) {
                stringifier = null;
            }
            if (stringifier != null) {
                result = stringifier.stringify(target);
            }
        }
        if (result == null) {
            result = target.toString();
        }
        return result;
    }

    public static String toString(Object target) {
        return DEFAULT.stringify(target);
    }

    public String stringify(Object target) {
        if (target == null) {
            return "<null>";
        }
        return this.smartStringify(target);
    }
}

