/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.stringifier;

import com.sun.appserv.management.util.stringifier.Stringifier;
import com.sun.appserv.management.util.stringifier.StringifierRegistry;
import com.sun.appserv.management.util.stringifier.StringifierRegistryImpl;

public class InterfacesStringifier
implements Stringifier {
    private final StringifierRegistry mRegistry;
    private final Class[] mInterfaces;

    public InterfacesStringifier(Class[] interfaces) {
        this(StringifierRegistryImpl.DEFAULT, interfaces);
    }

    public InterfacesStringifier(StringifierRegistry registry, Class[] interfaces) {
        this.mRegistry = registry;
        this.mInterfaces = interfaces;
    }

    private String stringifyAs(Object o, Class theClass) {
        Stringifier stringifier;
        String result = null;
        if (theClass.isAssignableFrom(o.getClass()) && (stringifier = this.mRegistry.lookup(theClass)) != null) {
            result = stringifier.stringify(o);
        }
        return result;
    }

    public String stringify(Object o) {
        String result = "";
        for (int i = 0; i < this.mInterfaces.length; ++i) {
            Class intf = this.mInterfaces[i];
            String s = this.stringifyAs(o, intf);
            if (s == null) continue;
            result = result + intf.getName() + ": " + s + "\n";
        }
        if (result == null || result.length() == 0) {
            result = o.toString();
        }
        return result;
    }
}

