/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.Tokenizer;
import com.sun.appserv.management.util.misc.TokenizerException;
import com.sun.appserv.management.util.misc.TokenizerInternal;
import com.sun.appserv.management.util.misc.TokenizerParams;
import java.util.ArrayList;
import java.util.Iterator;

public final class TokenizerImpl
implements Tokenizer {
    final String[] mTokens;
    private static final char QUOTE_CHAR = '\"';

    public TokenizerImpl(String input) throws TokenizerException {
        this(input, new TokenizerParams());
    }

    public TokenizerImpl(String input, TokenizerParams params) throws TokenizerException {
        TokenizerInternal worker = new TokenizerInternal(input, params);
        ArrayList allTokens = worker.parseTokens();
        if (params.mMultipleDelimsCountAsOne) {
            allTokens = TokenizerImpl.removeMultipleDelims(allTokens);
        }
        this.mTokens = TokenizerImpl.interpretTokenList(allTokens);
    }

    static final ArrayList removeMultipleDelims(ArrayList list) {
        ArrayList resultList = new ArrayList();
        boolean lastWasDelim = false;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object value = iter.next();
            if (value instanceof String) {
                resultList.add(value);
                lastWasDelim = false;
                continue;
            }
            if (lastWasDelim) continue;
            resultList.add(value);
            lastWasDelim = true;
        }
        return resultList;
    }

    static String[] interpretTokenList(ArrayList list) {
        ArrayList resultList = new ArrayList();
        boolean lastWasDelim = true;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object value = iter.next();
            if (value instanceof String) {
                resultList.add(value);
                lastWasDelim = false;
                continue;
            }
            if (lastWasDelim) {
                resultList.add("");
                continue;
            }
            lastWasDelim = true;
        }
        if (lastWasDelim && list.size() != 0) {
            resultList.add("");
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    public String[] getTokens() {
        return this.mTokens;
    }
}

