/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class ThrowableMapper {
    final Throwable mOriginal;
    final Set mOKPackages;
    protected static final Set OK_PACKAGES = Collections.unmodifiableSet(SetUtil.newSet("java.", "javax.", "com.sun.appserv.management."));

    public ThrowableMapper(Throwable t) {
        this.mOriginal = t;
        this.mOKPackages = OK_PACKAGES;
    }

    protected boolean shouldMap(Throwable t) {
        String tClass = t.getClass().getName();
        boolean shouldMap = true;
        Iterator iter = this.mOKPackages.iterator();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            if (!tClass.startsWith(prefix)) continue;
            shouldMap = false;
            break;
        }
        return shouldMap;
    }

    protected String getFullMsg(Throwable t) {
        String msg = t.getClass().getName() + ": " + t.getMessage() + ":\n" + ExceptionUtil.getStackTrace(t);
        return msg;
    }

    protected Throwable map(Throwable t) {
        Throwable result = t;
        if (t != null) {
            Throwable tCause = t.getCause();
            Throwable tCauseMapped = this.map(tCause);
            if (this.shouldMap(t) || tCauseMapped != tCause) {
                String fullMsg = this.getFullMsg(t);
                result = t instanceof Error ? new Error(fullMsg, tCauseMapped) : (t instanceof RuntimeException ? new RuntimeException(fullMsg, tCauseMapped) : new Exception(fullMsg, tCauseMapped));
            } else {
                result = t;
            }
        }
        return result;
    }

    public Throwable map() {
        return this.map(this.mOriginal);
    }
}

