/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.stringifier.SmartStringifier;

public final class StringUtil {
    public static final char QUOTE_CHAR = '\"';
    public static final String QUOTE = "\"";
    public static final String LS = System.getProperty("line.separator", "\n");

    private StringUtil() {
    }

    public static String quote(Object o) {
        return StringUtil.quote(o, '\"');
    }

    public static String quote(Object o, char leftHandChar) {
        String s = o == null ? "null" : SmartStringifier.toString(o);
        char leftChar = leftHandChar;
        char rightChar = leftHandChar;
        if (leftHandChar == '(') {
            rightChar = ')';
        } else if (leftHandChar == '{') {
            rightChar = '}';
        } else if (leftHandChar == '[') {
            rightChar = ']';
        } else if (leftHandChar == '<') {
            rightChar = '>';
        }
        String out = leftChar + s + rightChar;
        return out;
    }

    public static String toHexString(byte theByte) {
        String result = Integer.toHexString(theByte & 0xFF);
        if (result.length() == 1) {
            result = "0" + result;
        }
        return result;
    }

    public static String toHexString(byte[] bytes) {
        return StringUtil.toHexString(bytes, null);
    }

    public static String toHexString(byte[] bytes, String delim) {
        StringBuffer buf = new StringBuffer();
        if (bytes.length != 0) {
            if (delim == null || delim.length() == 0) {
                for (int i = 0; i < bytes.length; ++i) {
                    buf.append(StringUtil.toHexString(bytes[i]));
                }
            } else {
                for (int i = 0; i < bytes.length; ++i) {
                    buf.append(StringUtil.toHexString(bytes[i]) + delim);
                }
                buf.setLength(buf.length() - 1);
            }
        }
        return buf.toString();
    }

    public static String stripSuffix(String s, String suffix) {
        String result = s;
        if (s.endsWith(suffix)) {
            result = s.substring(0, s.length() - suffix.length());
        }
        return result;
    }

    public static String replaceSuffix(String s, String fromSuffix, String toSuffix) {
        if (!s.endsWith(fromSuffix)) {
            throw new IllegalArgumentException(fromSuffix);
        }
        return StringUtil.stripSuffix(s, fromSuffix) + toSuffix;
    }

    public static String stripPrefix(String s, String prefix) {
        String result = s;
        if (s.startsWith(prefix)) {
            result = s.substring(prefix.length(), s.length());
        }
        return result;
    }

    public static String stripPrefixAndSuffx(String s, String prefix, String suffix) {
        return StringUtil.stripPrefix(StringUtil.stripSuffix(s, suffix), prefix);
    }

    public static String upperCaseFirstLetter(String s) {
        String result = s;
        if (s.length() >= 1) {
            result = s.substring(0, 1).toUpperCase() + s.substring(1, s.length());
        }
        return result;
    }
}

