/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx.stringifier;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ListUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.stringifier.Stringifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;

public final class ObjectNameStringifier
implements Stringifier {
    public static final ObjectNameStringifier DEFAULT = new ObjectNameStringifier();
    private static List PROPS = null;
    private List mOrderedProps;
    private boolean mOmitDomain;

    private static synchronized List getPROPS() {
        if (PROPS == null) {
            PROPS = Collections.unmodifiableList(ListUtil.newList(new String[]{"j2eeType", "type", "name", "J2EEDomain", "J2EEServer", "JVM", "Node", "J2EEApplication", "AppClientModule", "EJBModule", "EntityBean", "StatefulSessionBean", "StatelessSessionBean", "MessageDrivenBean", "WebModule", "Servlet", "ResourceAdapterModule", "JavaMailResource", "JCAResource", "JCAConnectionFactory", "JCAManagedConnectionFactory", "JDBCResource", "JDBCDataSource", "JDBCDriver", "JMSResource", "JNDIResource", "JTAResource", "RMI_IIOPResource", "URL_Resource"}));
        }
        return PROPS;
    }

    public ObjectNameStringifier() {
        this(ObjectNameStringifier.getPROPS());
    }

    public ObjectNameStringifier(List props) {
        this.mOrderedProps = props;
        this.mOmitDomain = false;
    }

    public ObjectNameStringifier(String[] props) {
        this(ListUtil.newList(props));
    }

    public String stringify(Object o) {
        if (o == null) {
            return "null";
        }
        ObjectName on = (ObjectName)o;
        StringBuffer buf = new StringBuffer();
        if (!this.mOmitDomain) {
            buf.append(on.getDomain() + ":");
        }
        Hashtable<String, String> props = on.getKeyPropertyList();
        ArrayList ordered = new ArrayList(this.mOrderedProps);
        ordered.retainAll(props.keySet());
        Iterator iter = ordered.iterator();
        while (iter.hasNext() && props.keySet().size() >= 2) {
            String key = (String)iter.next();
            String value = (String)props.get(key);
            if (value == null) continue;
            buf.append(JMXUtil.makeProp(key, value) + ",");
            props.remove(key);
        }
        Set remainingSet = props.keySet();
        Object[] remaining = new String[remainingSet.size()];
        remainingSet.toArray(remaining);
        Arrays.sort(remaining);
        for (int i = 0; i < remaining.length; ++i) {
            Object key = remaining[i];
            String value = (String)props.get(key);
            buf.append(JMXUtil.makeProp((String)key, value) + ",");
        }
        String result = StringUtil.stripSuffix(buf.toString(), ",");
        return result;
    }

    public List getProps() {
        return this.mOrderedProps;
    }

    public void setProps(List props) {
        this.mOrderedProps = props;
    }

    public boolean getOmitDomain() {
        return this.mOmitDomain;
    }

    public void setOmitDomain(boolean omit) {
        this.mOmitDomain = omit;
    }
}

