/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx;

import com.sun.appserv.management.util.jmx.NotificationBuilder;
import com.sun.appserv.management.util.jmx.NotificationSender;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.management.Notification;

public final class NotificationLoggingHandler
extends Handler {
    private final Object mSource;
    private boolean mEmitNotifications;
    private final NotificationSender mSender;
    private NotificationBuilder mBuilder;

    public NotificationLoggingHandler(Object source, NotificationSender sender) {
        this.mSource = source;
        this.mEmitNotifications = false;
        this.mSender = sender;
        this.mBuilder = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NotificationBuilder getBuilder() {
        if (this.mBuilder == null) {
            NotificationLoggingHandler notificationLoggingHandler = this;
            synchronized (notificationLoggingHandler) {
                this.mBuilder = new NotificationBuilder("javax.enterprise.system.tools.admin.LogRecord", this.mSource);
            }
        }
        return this.mBuilder;
    }

    public boolean getEmitNotifications() {
        return this.mEmitNotifications;
    }

    public void setEmitNotifications(boolean emit) {
        this.mEmitNotifications = emit;
    }

    public void close() {
    }

    public void flush() {
    }

    private Notification buildNew(LogRecord record) {
        Notification notif = this.mBuilder.buildNew("LogRecord", record);
        return notif;
    }

    public void publish(LogRecord record) {
        if (this.getEmitNotifications()) {
            Notification notif = this.buildNew(record);
            this.mSender.sendNotification(notif);
        }
    }

    protected void reportError(String msg, Exception ex, int code) {
    }
}

