/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class NotificationEmitterSupport
extends NotificationBroadcasterSupport {
    private int mNumListeners = 0;
    private final boolean mAsyncDelivery;
    private SenderThread mSenderThread;
    private Logger mLogger;

    public NotificationEmitterSupport(boolean asyncDelivery) {
        this.mAsyncDelivery = asyncDelivery;
        this.mSenderThread = null;
        this.mLogger = Logger.getLogger(this.getClass().getPackage().getName());
    }

    private synchronized SenderThread getSenderThread() {
        if (this.mSenderThread == null) {
            SenderThread senderThread = this.mSenderThread = this.mAsyncDelivery ? new SenderThread() : null;
            if (this.mSenderThread != null) {
                this.mSenderThread.start();
            }
        }
        return this.mSenderThread;
    }

    public synchronized void cleanup() {
        if (this.mSenderThread != null) {
            this.mSenderThread.quit();
            this.mSenderThread = null;
        }
    }

    public void setLogger(Logger logger) {
        this.mLogger = logger;
    }

    public Logger getLogger() {
        return this.mLogger;
    }

    private boolean doLog() {
        return this.getLogger() != null;
    }

    private void finest(Object o) {
        if (this.getLogger() != null) {
            this.getLogger().finest(o.toString());
        }
    }

    public void sendAll() {
        if (this.mSenderThread != null) {
            this.mSenderThread.sendAll();
        }
    }

    public int getNumListeners() {
        return this.mNumListeners;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (this.doLog()) {
            this.finest("NotificationEmitterSupport.addNotificationListener: " + listener + " with filter " + filter);
        }
        super.addNotificationListener(listener, filter, handback);
        ++this.mNumListeners;
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (this.doLog()) {
            this.finest("NotificationEmitterSupport.removeNotificationListener: " + listener);
        }
        super.removeNotificationListener(listener);
        --this.mNumListeners;
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (this.doLog()) {
            this.finest("NotificationEmitterSupport.removeNotificationListener: " + listener + " filter = " + filter + " handback = " + handback);
        }
        super.removeNotificationListener(listener, filter, handback);
        --this.mNumListeners;
    }

    protected void internalSendNotification(Notification notif) {
        this.finest("NotificationEmitterSupport.internalSendNotification: " + notif);
        super.sendNotification(notif);
    }

    public void sendNotification(Notification notif) {
        if (this.getNumListeners() != 0) {
            if (this.getSenderThread() != null) {
                this.mSenderThread.enqueue(notif);
            } else {
                this.internalSendNotification(notif);
            }
        }
    }

    private final class SenderThread
    extends Thread {
        private boolean mQuit = false;
        private List mPendingNotifications = Collections.synchronizedList(new LinkedList());

        public void quit() {
            this.mQuit = true;
            this.notifySelf();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifySelf() {
            SenderThread senderThread = this;
            synchronized (senderThread) {
                this.notify();
            }
        }

        private void enqueue(Notification notif) {
            this.mPendingNotifications.add(notif);
            this.notifySelf();
        }

        public boolean sendAll() {
            Notification notif = null;
            boolean sentSomething = false;
            while (!this.mPendingNotifications.isEmpty()) {
                sentSomething = true;
                try {
                    notif = (Notification)this.mPendingNotifications.remove(0);
                    NotificationEmitterSupport.this.internalSendNotification(notif);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
            return sentSomething;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int INTERVAL = 5000;
            this.mQuit = false;
            while (!this.mQuit) {
                try {
                    SenderThread senderThread = this;
                    synchronized (senderThread) {
                        this.wait(5000L);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.mQuit) break;
                boolean sentSomething = this.sendAll();
                if (sentSomething) continue;
                NotificationEmitterSupport.this.cleanup();
                this.sendAll();
                break;
            }
            NotificationEmitterSupport.this.finest("NotificationEmitterSupport.SendThead.run: exiting");
        }
    }
}

