/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.management.Notification;

public class NotificationBuilder {
    private long mSequenceNumber = 0L;
    private final String mNotificationType;
    private final Object mSource;

    protected synchronized long nextSequenceNumber() {
        return this.mSequenceNumber++;
    }

    public NotificationBuilder(String notificationType, Object source) {
        this.mNotificationType = notificationType;
        this.mSource = source;
    }

    public final String getNotificationType() {
        return this.mNotificationType;
    }

    public final Object getSource() {
        return this.mSource;
    }

    protected final long now() {
        return System.currentTimeMillis();
    }

    public Notification buildNew() {
        Notification notif = new Notification(this.mNotificationType, this.mSource, this.nextSequenceNumber(), this.now());
        HashMap m = new HashMap();
        notif.setUserData(m);
        return notif;
    }

    public Notification buildNew(String key, Object value) {
        Notification notif = this.buildNew();
        if (key != null) {
            NotificationBuilder.putMapData(notif, key, value);
        }
        return notif;
    }

    public static final void putMapData(Notification notif, String key, Object value) {
        if (!(value instanceof Serializable)) {
            throw new IllegalArgumentException("not serializable: " + value);
        }
        ((Map)notif.getUserData()).put(key, value);
    }
}

