/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx;

import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.util.jmx.AttributeNameMangler;
import com.sun.appserv.management.util.jmx.AttributeNameMapper;
import com.sun.appserv.management.util.jmx.AttributeNameMapperImpl;
import com.sun.appserv.management.util.jmx.JMXUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class MBeanProxyHandler
extends MBeanServerInvocationHandler {
    protected static final String GET = "get";
    protected static final String SET = "set";
    protected static final String IS = "is";
    protected static final int GET_PREFIX_LENGTH;
    protected static final int IS_PREFIX_LENGTH;
    protected final ConnectionSource mConnectionSource;
    protected AttributeNameMangler mMangler;
    private AttributeNameMapper mMapper;
    private final ObjectName mTargetObjectName;
    private boolean mCacheMBeanInfo;
    private MBeanInfo mCachedMBeanInfo;
    private boolean mMBeanInfoIsInvariant = false;
    private Logger mLogger;
    private boolean mTargetValid;
    protected static final String LOGGER_NAME = "com.sun.appserv.management.Proxy";
    private final String LOG_LEVEL_NAME = "LogLevel";
    static final /* synthetic */ boolean $assertionsDisabled;

    public MBeanProxyHandler(ConnectionSource connectionSource, ObjectName objectName) throws IOException {
        this(connectionSource, objectName, (AttributeNameMangler)null);
    }

    private MBeanProxyHandler(ConnectionSource connectionSource, ObjectName objectName, AttributeNameMapper mapper, AttributeNameMangler mangler) throws IOException {
        super(connectionSource.getMBeanServerConnection(false), objectName);
        this.mMangler = mangler;
        this.mMapper = mapper;
        this.mConnectionSource = connectionSource;
        this.mTargetObjectName = objectName;
        this.mTargetValid = true;
        this.mCacheMBeanInfo = true;
        this.mCachedMBeanInfo = null;
        this.mLogger = null;
    }

    public final void targetUnregistered() {
        this.mTargetValid = false;
        if (!$assertionsDisabled && this.targetIsValid()) {
            throw new AssertionError();
        }
    }

    public final void connectionBad() {
        this.mTargetValid = false;
        if (!$assertionsDisabled && this.targetIsValid()) {
            throw new AssertionError();
        }
    }

    protected final boolean targetIsValid() {
        return this.mTargetValid;
    }

    public final boolean checkValid() {
        if (this.mTargetValid) {
            try {
                this.mTargetValid = this.getConnection().isRegistered(this.getTargetObjectName());
            }
            catch (Exception e) {
                this.mTargetValid = false;
            }
        }
        return this.mTargetValid;
    }

    public MBeanProxyHandler(ConnectionSource connectionSource, ObjectName objectName, AttributeNameMangler mangler) throws IOException {
        this(connectionSource, objectName, null, mangler);
    }

    public MBeanProxyHandler(ConnectionSource connectionSource, ObjectName objectName, AttributeNameMapper mapper) throws IOException {
        this(connectionSource, objectName, mapper, null);
    }

    public void setProxyLogger(Logger logger) {
        this.mLogger = logger;
    }

    public Logger getProxyLogger() {
        if (this.mLogger == null) {
            this.mLogger = Logger.getLogger(this.getClass().getName());
        }
        return this.mLogger;
    }

    public final ConnectionSource getConnectionSource() {
        return this.mConnectionSource;
    }

    protected final MBeanServerConnection getConnection() throws IOException {
        return this.mConnectionSource.getMBeanServerConnection(false);
    }

    protected final ObjectName getTargetObjectName() {
        return this.mTargetObjectName;
    }

    public static String[] getAllAttributeNames(MBeanAttributeInfo[] infos) {
        return JMXUtil.getAttributeNames(infos);
    }

    AttributeNameMapper createMapper(MBeanAttributeInfo[] attributeInfos, AttributeNameMangler mangler) {
        return new AttributeNameMapperImpl(MBeanProxyHandler.getAllAttributeNames(attributeInfos), mangler);
    }

    protected void initMapper() throws IOException, IntrospectionException, ReflectionException, InstanceNotFoundException {
        if (this.mMapper == null && this.mMangler != null) {
            MBeanInfo mbeanInfo = this.getMBeanInfo(true);
            this.mMapper = this.createMapper(mbeanInfo.getAttributes(), this.mMangler);
        }
    }

    protected String extractAttributeNameFromMethod(String methodName) {
        if (!($assertionsDisabled || methodName.startsWith(GET) || methodName.startsWith(SET) || methodName.startsWith(IS))) {
            throw new AssertionError();
        }
        int startIndex = methodName.startsWith(GET) || methodName.startsWith(SET) ? GET_PREFIX_LENGTH : IS_PREFIX_LENGTH;
        return methodName.substring(startIndex, methodName.length());
    }

    protected boolean isMappedAttributeMethod(String attributeName) {
        boolean isMapped = false;
        if (this.mMapper != null) {
            String originalName = this.mMapper.derivedToOriginal(attributeName);
            isMapped = !attributeName.equals(originalName);
        }
        return isMapped;
    }

    protected void cacheMBeanInfo(boolean cacheIt) {
        this.mCacheMBeanInfo = cacheIt;
        this.mMBeanInfoIsInvariant = cacheIt;
        if (!cacheIt) {
            this.mCachedMBeanInfo = null;
        }
    }

    public final boolean getMBeanInfoIsInvariant() {
        return this.mMBeanInfoIsInvariant;
    }

    protected final void setMBeanInfoIsInvariant(boolean isInvariant) {
        this.mMBeanInfoIsInvariant = isInvariant;
    }

    protected final boolean getCacheMBeanInfo() {
        return this.mCacheMBeanInfo;
    }

    protected MBeanInfo getMBeanInfo(boolean refresh) throws IOException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (refresh || !this.mCacheMBeanInfo || this.mCachedMBeanInfo == null) {
            this.mCachedMBeanInfo = this.getConnection().getMBeanInfo(this.getTargetObjectName());
        }
        return this.mCachedMBeanInfo;
    }

    public Object getAttribute(String attributeName) throws InstanceNotFoundException, ReflectionException, MBeanException, AttributeNotFoundException, IOException {
        Object result = this.getConnection().getAttribute(this.getTargetObjectName(), attributeName);
        this.postGetAttributeHook(attributeName, result);
        return result;
    }

    public AttributeList getAttributes(String[] attrNames) throws IOException, InstanceNotFoundException, ReflectionException {
        AttributeList results = this.getConnection().getAttributes(this.getTargetObjectName(), attrNames);
        this.postGetAttributesHook(attrNames, results);
        return results;
    }

    public void setAttribute(Attribute attr) throws IOException, InstanceNotFoundException, ReflectionException, AttributeNotFoundException, MBeanException, InvalidAttributeValueException {
        this.getConnection().setAttribute(this.getTargetObjectName(), attr);
        this.postSetAttributeHook(attr);
    }

    public AttributeList setAttributes(AttributeList requested) throws IOException, InstanceNotFoundException, ReflectionException {
        AttributeList results = this.getConnection().setAttributes(this.getTargetObjectName(), requested);
        this.postSetAttributesHook(requested, results);
        return results;
    }

    protected void postGetAttributeHook(String name, Object value) {
    }

    protected void postGetAttributesHook(String[] requested, AttributeList actual) {
    }

    protected void postSetAttributeHook(Attribute attr) {
    }

    protected void postSetAttributesHook(AttributeList requested, AttributeList actual) {
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        int numArgs = args == null ? 0 : args.length;
        this.trace("MBeanProxyHandler.invoke: " + method.toString());
        Object result = null;
        boolean isGetter = JMXUtil.isIsOrGetter(method);
        boolean isSetter = isGetter ? false : JMXUtil.isSetter(method);
        boolean handled = false;
        if (methodName.equals("getTargetObjectName")) {
            handled = true;
            result = this.getTargetObjectName();
        } else if (methodName.equals("getMBeanInfo") && numArgs <= 1) {
            handled = true;
            if (numArgs == 1) {
                result = this.getMBeanInfo((Boolean)args[0]);
            } else if (numArgs == 0) {
                result = this.getMBeanInfo(this.mCacheMBeanInfo);
            } else {
                handled = false;
            }
        } else if (methodName.equals("getProxyLogger") && numArgs == 0) {
            handled = true;
            result = this.getProxyLogger();
        } else if (methodName.equals("setProxyLogger") && numArgs == 1 && method.getParameterTypes()[0] == Logger.class) {
            handled = true;
            this.setProxyLogger((Logger)args[0]);
        } else if (isGetter || isSetter) {
            String javaName;
            handled = true;
            this.initMapper();
            String attributeName = javaName = this.extractAttributeNameFromMethod(methodName);
            if (this.isMappedAttributeMethod(javaName)) {
                attributeName = this.mMapper.derivedToOriginal(javaName);
            }
            if (isGetter) {
                result = this.getAttribute(attributeName);
            } else {
                Attribute attr = new Attribute(attributeName, args[0]);
                this.setAttribute(attr);
            }
        } else if (methodName.indexOf("etAttribute") == 1) {
            handled = true;
            if (JMXUtil.isGetAttribute(method)) {
                String attrName = (String)args[0];
                result = this.getAttribute(attrName);
            } else if (JMXUtil.isGetAttributes(method)) {
                String[] attrNames = (String[])args[0];
                result = this.getAttributes(attrNames);
            } else if (JMXUtil.isSetAttribute(method)) {
                Attribute attr = (Attribute)args[0];
                this.setAttribute(attr);
            } else if (JMXUtil.isSetAttributes(method)) {
                AttributeList requested = (AttributeList)args[0];
                result = this.setAttributes(requested);
            } else {
                handled = false;
            }
        }
        if (!handled) {
            result = super.invoke(proxy, method, args);
        }
        return result;
    }

    protected void trace(Object o) {
        if (this.mLogger != null) {
            this.mLogger.fine(o.toString());
        }
    }

    static {
        $assertionsDisabled = !MBeanProxyHandler.class.desiredAssertionStatus();
        GET_PREFIX_LENGTH = GET.length();
        IS_PREFIX_LENGTH = IS.length();
    }
}

