/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.client;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.AdminRMISSLClientSocketFactoryEnvImpl;
import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.HandshakeCompletedListenerImpl;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.client.TLSParams;
import com.sun.appserv.management.util.misc.MapUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.X509TrustManager;

public final class AppserverConnectionSource
implements NotificationListener,
ConnectionSource {
    private final String mHost;
    private final int mPort;
    private final String mProtocol;
    private final String mUser;
    private final String mPassword;
    private final TLSParams mTLSParams;
    private final Map mReserved;
    protected JMXConnector mJMXConnector;
    private static final boolean DISABLE_HANDSHAKE_COMPLETED_CHECK = true;
    public static final String TRUST_MANAGERS_KEY = "TRUST_MANAGER_KEY";
    public static final String HANDSHAKE_COMPLETED_LISTENER_KEY = "HandshakeCompletedListener";
    private static final String PROTOCOL_PREFIX = "sun-as-";
    public static final String PROTOCOL_RMI = "sun-as-rmi";
    public static final String DEFAULT_PROTOCOL = "sun-as-rmi";
    public static final String PROTOCOL_HTTP = "sun-as-http";
    private static final String INTERNAL_HTTP = "s1ashttp";
    private static final String INTERNAL_HTTPS = "s1ashttps";
    private static final String HTTP_FACTORY_PACKAGES = "com.sun.enterprise.admin.jmx.remote.protocol";
    private static final String APPSERVER_JNDI_NAME = "/management/rmi-jmx-connector";
    static final /* synthetic */ boolean $assertionsDisabled;

    private boolean disableHandShakeCompletedCheck() {
        return this.mProtocol.equals(PROTOCOL_HTTP);
    }

    public static boolean isSupportedProtocol(String protocol) {
        return protocol != null && (protocol.equals(PROTOCOL_HTTP) || protocol.equals("sun-as-rmi"));
    }

    public AppserverConnectionSource(String host, int port, String user, String password, Map reserved) {
        this("sun-as-rmi", host, port, user, password, reserved);
    }

    public AppserverConnectionSource(String protocol, String host, int port, String user, String password, Map reserved) {
        this(protocol, host, port, user, password, null, reserved);
    }

    public AppserverConnectionSource(String protocol, String host, int port, String user, String password, TLSParams tlsParams, Map reserved) {
        if (reserved != null && reserved.keySet().size() != 0) {
            throw new IllegalArgumentException("No parameters may be passed in 'reserved' Map");
        }
        if (!AppserverConnectionSource.isSupportedProtocol(protocol)) {
            throw new IllegalArgumentException("unsupported protocol: " + protocol + ", use either PROTOCOL_RMI or PROTOCOL_HTTP");
        }
        this.mHost = host;
        this.mPort = port;
        this.mProtocol = protocol;
        this.mUser = user;
        this.mPassword = password;
        this.mTLSParams = tlsParams;
        this.mReserved = reserved;
    }

    private Object envGet(String key) {
        return this.mReserved == null ? null : this.mReserved.get(key);
    }

    private final boolean useTLS() {
        return this.mTLSParams != null;
    }

    private final X509TrustManager[] getTrustManagers() {
        return this.mTLSParams == null ? null : this.mTLSParams.getTrustManagers();
    }

    private final HandshakeCompletedListener getSuppliedHandshakeCompletedListener() {
        return this.mTLSParams == null ? null : this.mTLSParams.getHandshakeCompletedListener();
    }

    private Map getCredentialsEnv(String user, String password) {
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        String[] credentials = new String[]{this.mUser, this.mPassword};
        env.put("jmx.remote.credentials", credentials);
        return env;
    }

    private void warning(String msg) {
        System.out.println("\n***\nWARNING: " + msg);
    }

    private JMXConnector createNew() throws MalformedURLException, IOException {
        Map env = this.getCredentialsEnv(this.mUser, this.mPassword);
        env.put("jmx.remote.protocol.provider.class.loader", this.getClass().getClassLoader());
        HandshakeCompletedListenerImpl hcListener = new HandshakeCompletedListenerImpl(this.getSuppliedHandshakeCompletedListener());
        JMXServiceURL url = null;
        if (this.mProtocol.equals(PROTOCOL_HTTP)) {
            if (this.useTLS()) {
                X509TrustManager[] tms = this.getTrustManagers();
                if (tms != null && tms.length >= 1) {
                    env.put(TRUST_MANAGERS_KEY, tms[0]);
                }
                env.put(HANDSHAKE_COMPLETED_LISTENER_KEY, hcListener);
            }
            env.put("com.sun.enterprise.as.http.auth", "BASIC");
            env.put("USER", this.mUser);
            env.put("PASSWORD", this.mPassword);
            env.put("jmx.remote.protocol.provider.pkgs", HTTP_FACTORY_PACKAGES);
            String internalProtocol = this.useTLS() ? INTERNAL_HTTPS : INTERNAL_HTTP;
            url = new JMXServiceURL(internalProtocol, this.mHost, this.mPort);
        } else if (this.mProtocol.equals("sun-as-rmi")) {
            if (this.useTLS()) {
                AdminRMISSLClientSocketFactoryEnvImpl rmiEnv = AdminRMISSLClientSocketFactoryEnvImpl.getInstance();
                rmiEnv.setHandshakeCompletedListener(hcListener);
                rmiEnv.setTrustManagers(this.getTrustManagers());
            }
            String s = "service:jmx:rmi:///jndi/rmi://" + this.mHost + ":" + this.mPort + APPSERVER_JNDI_NAME;
            url = new JMXServiceURL(s);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        JMXConnector conn = JMXConnectorFactory.connect(url, env);
        if (!this.disableHandShakeCompletedCheck() && this.useTLS() && hcListener.getLastEvent() == null) {
            conn.close();
            throw new IOException("Connection could not be established using TLS; server is not using TLS");
        }
        conn.addConnectionNotificationListener(this, null, conn);
        return conn;
    }

    public void handleNotification(Notification notifIn, Object handback) {
        JMXConnectionNotification notif;
        String type;
        if (notifIn instanceof JMXConnectionNotification && ((type = (notif = (JMXConnectionNotification)notifIn).getType()).equals("jmx.remote.connection.failed") || type.equals("jmx.remote.connection.closed"))) {
            this.mJMXConnector = null;
        }
    }

    public JMXConnector getJMXConnector(boolean forceNew) throws IOException {
        if (forceNew || this.mJMXConnector == null) {
            this.mJMXConnector = this.createNew();
            this.getMBeanServerConnection(false);
        }
        return this.mJMXConnector;
    }

    public MBeanServerConnection getExistingMBeanServerConnection() {
        try {
            return this.getJMXConnector(false).getMBeanServerConnection();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public MBeanServerConnection getMBeanServerConnection(boolean forceNew) throws IOException {
        return this.getJMXConnector(forceNew).getMBeanServerConnection();
    }

    public DomainRoot getDomainRoot() throws IOException {
        return ProxyFactory.getInstance(this).getDomainRoot();
    }

    public String toString() {
        return "protocol=" + this.mProtocol + ", host=" + this.mHost + ", port=" + this.mPort + ", user=" + this.mUser + ", useTLS={" + this.useTLS() + "}" + ", mReserved=" + (this.mReserved == null ? "null" : MapUtil.toString(this.mReserved));
    }

    static {
        $assertionsDisabled = !AppserverConnectionSource.class.desiredAssertionStatus();
    }
}

