/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.client;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.AMXClientLogger;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.Extra;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.PerMBeanCache;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.MBeanProxyHandler;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.appserv.management.util.stringifier.ArrayStringifier;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;

final class AMXProxyHandler
extends MBeanProxyHandler
implements Extra {
    protected final PerMBeanCache mCache = new PerMBeanCache();
    private boolean mCheckedForInvariantMBeanInfo = false;
    private final Integer mHashCode;
    private static final String CREATE = "create";
    private static final String GET = "get";
    private static final String MAP_SUFFIX = "Map";
    private static final String SET_SUFFIX = "Set";
    private static final String OBJECT_NAME_MAP_SUFFIX = "ObjectNameMap";
    private static final String OBJECT_NAME_SET_SUFFIX = "ObjectNameSet";
    private static final String OBJECT_NAME_SUFFIX = "ObjectName";
    private static final String CONTAINEE_J2EE_TYPES = "ContaineeJ2EETypes";
    private static final String CONTAINER = "Container";
    private static final String DOMAIN_ROOT = "DomainRoot";
    private static final String MBEAN_INFO = "MBeanInfo";
    private static final String ATTRIBUTE_NAMES = "AttributeNames";
    private static final String J2EE_NAME = "Name";
    private static final String J2EE_TYPE = "J2EEType";
    public static final String ADD_NOTIFICATION_LISTENER = "addNotificationListener";
    public static final String REMOVE_NOTIFICATION_LISTENER = "removeNotificationListener";
    private static final String QUERY = "query";
    private static final String STRING;
    private static final String[] EMPTY_SIG;
    private static final String[] STRING_SIG;
    private static final String[] STRING2_SIG;
    private static final String GET_SINGLETON_CONTAINEE = "getSingletonContainee";
    private static final String GET_CONTAINEE = "getContainee";
    private static final String GET_SINGLETON_CONTAINEE_OBJECT_NAME = "getSingletonContaineeObjectName";
    private static final String[] GET_SINGLETON_CONTAINEE_OBJECT_NAME_SIG1;
    private static final String[] GET_SINGLETON_CONTAINEE_OBJECT_NAME_SIG2;
    private static final String[] GET_OBJECT_NAMES_SIG_EMPTY;
    private static final String[] GET_OBJECT_NAMES_SIG_STRING;
    private static final Class[] NOTIFICATION_LISTENER_SIG1;
    private static final Class[] NOTIFICATION_LISTENER_SIG2;
    private static final Set CACHED_ATTRIBUTE_NAMES;
    private static final String GET_MBEAN_INFO = "getMBeanInfo";
    private static final String GET_J2EE_TYPE = "getJ2EEType";
    private static final String GET_J2EE_NAME = "getName";
    private static final String GET_ATTRIBUTE_NAMES = "getAttributeNames";
    private static final String GET_CONTAINER = "getContainer";
    private static final String GET_EXTRA = "getExtra";
    private static final String GET_ALL_ATTRIBUTES = "getAllAttributes";
    private static final String GET_DOMAIN_ROOT = "getDomainRoot";
    private static final String GET_OBJECT_NAME = "getObjectName";
    private static final Set SPECIAL_METHOD_NAMES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AMXProxyHandler(ConnectionSource connectionSource, ObjectName proxiedMBeanObjectName) throws IOException {
        super(connectionSource, proxiedMBeanObjectName);
        this.setProxyLogger(AMXClientLogger.getInstance());
        this.mHashCode = new Integer(this.hashCode());
    }

    protected void cacheAttribute(Attribute attr) {
        this.mCache.cacheAttribute(attr);
    }

    protected Attribute getCachedAttribute(String attrName) throws IOException, InstanceNotFoundException, MBeanException, AttributeNotFoundException, ReflectionException {
        Attribute attr = this.mCache.getCachedAttribute(attrName);
        if (attr == null) {
            MBeanServerConnection conn = this.getConnection();
            Object value = this.getConnection().getAttribute(this.getTargetObjectName(), attrName);
            attr = new Attribute(attrName, value);
            this.mCache.cacheAttribute(attr);
        }
        return attr;
    }

    protected Object getCachedAttributeValue(String attrName) throws IOException, JMException {
        Attribute attr = this.getCachedAttribute(attrName);
        if (!$assertionsDisabled && attr == null) {
            throw new AssertionError((Object)("getCachedAttributeValue: null for " + attrName));
        }
        return attr == null ? null : attr.getValue();
    }

    private AMX getCachedProxy(Object key) {
        AMXProxyHandler handler;
        AMX proxy = null;
        proxy = key instanceof ObjectName ? this.getProxyFactory().getProxy((ObjectName)key) : (AMX)this.mCache.getCachedItem(key);
        if (proxy != null && !(handler = (AMXProxyHandler)Proxy.getInvocationHandler(proxy)).targetIsValid()) {
            this.trace("removing cached proxy for key: " + key);
            this.mCache.remove(key);
            proxy = null;
        }
        return proxy;
    }

    private void cacheProxy(String key, AMX proxy) {
        this.mCache.cacheItem(key, proxy);
    }

    protected ObjectName getContainerObjectName() throws IOException, JMException {
        return (ObjectName)this.getCachedAttributeValue("ContainerObjectName");
    }

    protected Class getProxyInterface(ObjectName objectName) throws IOException, JMException, ClassNotFoundException {
        AMX proxy = this.getProxyFactory().getProxy(objectName);
        Class proxyInterface = ClassUtil.getClassFromName(Util.getExtra(proxy).getInterfaceName());
        return proxyInterface;
    }

    private String _getInterfaceName() throws IOException, JMException {
        return (String)this.getCachedAttributeValue("InterfaceName");
    }

    public String getInterfaceName() {
        try {
            return this._getInterfaceName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ProxyFactory getProxyFactory() {
        return ProxyFactory.getInstance(this.getConnectionSource());
    }

    synchronized Container getContainer(AMX myProxy) throws IOException, JMException, ClassNotFoundException {
        Container containerProxy = null;
        if (!(myProxy instanceof DomainRoot)) {
            containerProxy = (Container)this.getProxyFactory().getProxy(this.getContainerObjectName());
        }
        return containerProxy;
    }

    private final DomainRoot getDomainRoot() throws IOException {
        return this.getProxyFactory().getDomainRoot();
    }

    protected synchronized AMX createProxy(ObjectName objectName) {
        return this.getProxyFactory().getProxy(objectName);
    }

    public static boolean isProxyMapGetter(Method method, int argCount) {
        boolean isProxyMapGetter = false;
        String name = method.getName();
        if (name.startsWith(GET) && name.endsWith(MAP_SUFFIX) && !name.endsWith(OBJECT_NAME_MAP_SUFFIX) && argCount <= 1 && Map.class.isAssignableFrom(method.getReturnType())) {
            isProxyMapGetter = true;
        }
        return isProxyMapGetter;
    }

    public static boolean isSingleProxyGetter(Method method, int argCount) {
        boolean isProxyGetter = false;
        String name = method.getName();
        if ((name.startsWith(GET) || name.startsWith(QUERY)) && argCount <= 2 && AMX.class.isAssignableFrom(method.getReturnType())) {
            isProxyGetter = true;
        }
        return isProxyGetter;
    }

    public static boolean isProxySetGetter(Method method, int argCount) {
        boolean isProxySetGetter = false;
        String name = method.getName();
        if ((name.startsWith(GET) || name.startsWith(QUERY)) && name.endsWith(SET_SUFFIX) && !name.endsWith(OBJECT_NAME_SET_SUFFIX) && argCount <= 2 && Set.class.isAssignableFrom(method.getReturnType())) {
            isProxySetGetter = true;
        }
        return isProxySetGetter;
    }

    private static String proxyGetterToObjectNameGetter(String methodName) {
        return methodName + OBJECT_NAME_SUFFIX;
    }

    private Object invokeTarget(String methodName, Object[] args, String[] sig) throws IOException, ReflectionException, InstanceNotFoundException, MBeanException {
        return this.getConnection().invoke(this.getTargetObjectName(), methodName, args, sig);
    }

    private String getJ2EEType(Class c) {
        return (String)ClassUtil.getFieldValue(c, "J2EE_TYPE");
    }

    AMX invokeSingleProxyGetter(Object myProxy, Method method, Object[] args) throws IOException, ReflectionException, InstanceNotFoundException, MBeanException {
        String methodName = method.getName();
        int numArgs = args == null ? 0 : args.length;
        String argString = args == null ? "" : ArrayStringifier.stringify(args, "_");
        String cacheKey = methodName + argString;
        AMX proxy = this.getCachedProxy(cacheKey);
        if (proxy == null) {
            Class<?> returnClass = method.getReturnType();
            ObjectName objectName = null;
            String j2eeType = this.getJ2EEType(returnClass);
            if (numArgs == 0) {
                String newMethodName = AMXProxyHandler.proxyGetterToObjectNameGetter(methodName);
                objectName = (ObjectName)this.invokeTarget(newMethodName, null, EMPTY_SIG);
            } else if (numArgs == 1 && args[0].getClass() == String.class) {
                String newMethodName = AMXProxyHandler.proxyGetterToObjectNameGetter(methodName);
                objectName = (ObjectName)this.invokeTarget(newMethodName, args, STRING_SIG);
            } else if ((methodName.equals(GET_SINGLETON_CONTAINEE) || methodName.equals(GET_CONTAINEE)) && numArgs == 2) {
                String newMethodName = AMXProxyHandler.proxyGetterToObjectNameGetter(methodName);
                objectName = (ObjectName)this.invokeTarget(newMethodName, args, GET_SINGLETON_CONTAINEE_OBJECT_NAME_SIG2);
            } else {
                this.getProxyLogger().warning("Unknown form of proxy getter: " + method);
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                throw new IllegalArgumentException();
            }
            if (objectName != null) {
                proxy = this.createProxy(objectName);
            }
            if (proxy != null) {
                if (cacheKey != null) {
                    this.cacheProxy(cacheKey, proxy);
                }
            } else {
                this.getProxyLogger().fine("invokeSingleProxyGetter: NULL proxy for: " + methodName);
            }
        }
        return proxy;
    }

    public static boolean isProxyCreator(Method method) {
        String methodName = method.getName();
        return methodName.startsWith(CREATE) && AMX.class.isAssignableFrom(method.getReturnType());
    }

    AMX invokeProxyCreator(Method method, Object[] args) throws IOException, ReflectionException, InstanceNotFoundException, MBeanException {
        String methodName = method.getName();
        String[] stringSig = AMXProxyHandler.getStringSig(method);
        ObjectName objectName = (ObjectName)this.invokeTarget(methodName, args, stringSig);
        if (!$assertionsDisabled && objectName == null) {
            throw new AssertionError((Object)("received null ObjectName from: " + methodName + " on target " + this.getTargetObjectName()));
        }
        AMX proxy = this.createProxy(objectName);
        if (!$assertionsDisabled && this.getProxyFactory().getProxy(Util.getExtra(proxy).getObjectName(), false) != proxy) {
            throw new AssertionError();
        }
        return proxy;
    }

    private static String toString(Object o) {
        return SmartStringifier.toString(o);
    }

    private static String[] getStringSig(Method method) {
        Class[] sig = method.getParameterTypes();
        String[] stringSig = ClassUtil.classnamesFromSignature(sig);
        return stringSig;
    }

    public static String convertMethodName(String srcName, String srcSuffix, String resultSuffix) {
        if (!srcName.endsWith(srcSuffix)) {
            throw new IllegalArgumentException(srcName + " does not end with " + srcSuffix);
        }
        String baseName = srcName.substring(0, srcName.indexOf(srcSuffix));
        return baseName + resultSuffix;
    }

    private Map invokeProxyMapGetter(Object myProxy, Method method, Object[] args) throws IOException, ReflectionException, InstanceNotFoundException, MBeanException, ClassNotFoundException, AttributeNotFoundException, JMException {
        int argCount = args == null ? 0 : args.length;
        String methodName = method.getName();
        String getObjectNameMapName = AMXProxyHandler.convertMethodName(methodName, MAP_SUFFIX, OBJECT_NAME_MAP_SUFFIX);
        MBeanServerConnection conn = this.getConnection();
        Map m = (Map)this.invokeTarget(getObjectNameMapName, args, AMXProxyHandler.getStringSig(method));
        if (!$assertionsDisabled && m == null) {
            throw new AssertionError((Object)("mbean " + this.getTargetObjectName() + " returned null Map for " + getObjectNameMapName));
        }
        HashMap<String, Map> result = Collections.EMPTY_MAP;
        Set keySet = m.keySet();
        if (keySet.size() != 0) {
            if (!$assertionsDisabled && MapUtil.getNullValueKeys(m).size() != 0) {
                throw new AssertionError();
            }
            String firstKey = (String)keySet.iterator().next();
            Object firstValue = m.get(firstKey);
            if (firstValue instanceof ObjectName) {
                result = this.getProxyFactory().toProxyMap(m);
            } else {
                if (!$assertionsDisabled && !(firstValue instanceof Map)) {
                    throw new AssertionError();
                }
                result = new HashMap<String, Map>();
                Iterator iter = keySet.iterator();
                while (iter.hasNext()) {
                    String j2eeType = (String)iter.next();
                    Object value = m.get(j2eeType);
                    if (!(value instanceof Map)) {
                        this.getProxyLogger().warning("expecting Map, got: " + value.getClass().getName() + " from " + methodName);
                    }
                    Map nameMap = (Map)value;
                    Map proxyMap = this.getProxyFactory().toProxyMap(nameMap);
                    result.put(j2eeType, proxyMap);
                }
            }
        }
        return result;
    }

    private Set invokeProxySetGetter(Object myProxy, Method method, Object[] args) throws IOException, JMException, ClassNotFoundException {
        if (!$assertionsDisabled && !Set.class.isAssignableFrom(method.getReturnType())) {
            throw new AssertionError();
        }
        String methodName = method.getName();
        String getObjectNamesName = AMXProxyHandler.convertMethodName(methodName, SET_SUFFIX, OBJECT_NAME_SET_SUFFIX);
        MBeanServerConnection conn = this.getConnection();
        String[] stringSig = AMXProxyHandler.getStringSig(method);
        Set objectNames = (Set)this.invokeTarget(getObjectNamesName, args, stringSig);
        Set proxies = this.getProxyFactory().toProxySet(objectNames);
        return proxies;
    }

    private MBeanInfo _getMBeanInfo() throws IOException, InstanceNotFoundException, ReflectionException, IntrospectionException {
        MBeanInfo mbeanInfo = null;
        if (!this.mCheckedForInvariantMBeanInfo) {
            this.mCheckedForInvariantMBeanInfo = true;
            try {
                Boolean cacheIt = (Boolean)this.getAttribute("MBeanInfoIsInvariant");
                this.setMBeanInfoIsInvariant(cacheIt);
                this.cacheMBeanInfo(cacheIt);
            }
            catch (Exception e) {
                this.cacheMBeanInfo(false);
                this.setMBeanInfoIsInvariant(false);
            }
        }
        mbeanInfo = this.getMBeanInfo(this.getCacheMBeanInfo());
        return mbeanInfo;
    }

    public MBeanInfo getMBeanInfo() {
        try {
            return this._getMBeanInfo();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectName getObjectName() {
        return this.getTargetObjectName();
    }

    public Map getAllAttributes() {
        Map result = Collections.EMPTY_MAP;
        try {
            String[] names = this.getAttributeNames();
            AttributeList attrs = this.getAttributes(names);
            result = JMXUtil.attributeListToValueMap(attrs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public String[] getAttributeNames() {
        String attrName = ATTRIBUTE_NAMES;
        Attribute attr = null;
        try {
            attr = this.getCachedAttribute(ATTRIBUTE_NAMES);
        }
        catch (AttributeNotFoundException e) {
            attr = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String[] names = null;
        if (attr == null) {
            MBeanInfo mbeanInfo = this.getMBeanInfo();
            names = JMXUtil.getAttributeNames(mbeanInfo.getAttributes());
            if (this.getMBeanInfoIsInvariant()) {
                this.cacheAttribute(new Attribute(ATTRIBUTE_NAMES, names));
            }
        } else {
            names = (String[])attr.getValue();
        }
        return names;
    }

    private Object handleSpecialMethod(Object myProxy, Method method, Object[] args) throws ClassNotFoundException, JMException, IOException {
        String methodName = method.getName();
        int numArgs = args == null ? 0 : args.length;
        Object result = null;
        boolean handled = true;
        if (numArgs == 0) {
            if (methodName.equals(GET_CONTAINER)) {
                result = this.getContainer((AMX)myProxy);
            } else if (methodName.equals(GET_EXTRA)) {
                if (!$assertionsDisabled && !(this instanceof Extra)) {
                    throw new AssertionError();
                }
                result = this;
            } else if (methodName.equals(GET_OBJECT_NAME)) {
                result = this.getTargetObjectName();
            } else if (methodName.equals(GET_DOMAIN_ROOT)) {
                result = this.getDomainRoot();
            } else if (methodName.equals(GET_ATTRIBUTE_NAMES)) {
                result = this.getAttributeNames();
            } else if (methodName.equals(GET_J2EE_TYPE)) {
                result = Util.getJ2EEType(this.getTargetObjectName());
            } else if (methodName.equals(GET_J2EE_NAME)) {
                result = Util.getName(this.getTargetObjectName());
            } else if (methodName.equals(GET_ALL_ATTRIBUTES)) {
                result = this.getAllAttributes();
            } else {
                handled = false;
            }
        } else {
            Class[] signature = method.getParameterTypes();
            if (methodName.equals(ADD_NOTIFICATION_LISTENER) && (ClassUtil.sigsEqual(NOTIFICATION_LISTENER_SIG1, signature) || ClassUtil.sigsEqual(NOTIFICATION_LISTENER_SIG2, signature))) {
                this.addNotificationListener(args);
            } else if (methodName.equals(REMOVE_NOTIFICATION_LISTENER) && (ClassUtil.sigsEqual(NOTIFICATION_LISTENER_SIG1, signature) || ClassUtil.sigsEqual(NOTIFICATION_LISTENER_SIG2, signature))) {
                this.removeNotificationListener(args);
            } else {
                handled = false;
            }
        }
        if (!handled) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException("unknown method: " + method);
        }
        return result;
    }

    public Object invoke(Object myProxy, Method method, Object[] args) throws Throwable {
        try {
            return this._invoke(myProxy, method, args);
        }
        catch (IOException e) {
            this.getProxyFactory().checkConnection();
            throw e;
        }
        catch (InstanceNotFoundException e) {
            this.checkValid();
            throw e;
        }
    }

    public Object _invoke(Object myProxy, Method method, Object[] args) throws Throwable {
        if (!this.targetIsValid()) {
            throw new InstanceNotFoundException(this.getTargetObjectName().toString());
        }
        Object result = null;
        String methodName = method.getName();
        int numArgs = args == null ? 0 : args.length;
        boolean handled = false;
        if (SPECIAL_METHOD_NAMES.contains(methodName)) {
            handled = true;
            result = methodName.equals("hashCode") && numArgs == 0 ? this.mHashCode : this.handleSpecialMethod(myProxy, method, args);
        } else if (JMXUtil.isIsOrGetter(method)) {
            if (!$assertionsDisabled && handled) {
                throw new AssertionError();
            }
            String attrName = JMXUtil.getAttributeName(method);
            if (CACHED_ATTRIBUTE_NAMES.contains(attrName)) {
                result = this.getCachedAttributeValue(attrName);
                handled = true;
            }
        }
        if (!handled) {
            result = AMXProxyHandler.isSingleProxyGetter(method, numArgs) ? this.invokeSingleProxyGetter(myProxy, method, args) : (AMXProxyHandler.isProxySetGetter(method, numArgs) ? this.invokeProxySetGetter(myProxy, method, args) : (AMXProxyHandler.isProxyMapGetter(method, numArgs) ? this.invokeProxyMapGetter(myProxy, method, args) : (AMXProxyHandler.isProxyCreator(method) ? this.invokeProxyCreator(method, args) : super.invoke(myProxy, method, args))));
            if (!($assertionsDisabled || result == null || ClassUtil.IsPrimitiveClass(method.getReturnType()) || method.getReturnType().isAssignableFrom(result.getClass()))) {
                throw new AssertionError((Object)(methodName + ": result of type " + result.getClass().getName() + " not assignable to " + method.getReturnType().getName() + ", " + "interfaces: " + AMXProxyHandler.toString(result.getClass().getInterfaces())));
            }
        }
        return result;
    }

    protected void addNotificationListener(Object[] args) throws IOException, InstanceNotFoundException {
        NotificationListener listener = (NotificationListener)args[0];
        NotificationFilter filter = (NotificationFilter)(args.length <= 1 ? null : args[1]);
        Object handback = args.length <= 1 ? null : args[2];
        this.getConnection().addNotificationListener(this.getTargetObjectName(), listener, filter, handback);
    }

    protected void removeNotificationListener(Object[] args) throws IOException, InstanceNotFoundException, ListenerNotFoundException {
        NotificationListener listener = (NotificationListener)args[0];
        NotificationFilter filter = (NotificationFilter)(args.length <= 1 ? null : args[1]);
        Object handback = args.length <= 1 ? null : args[2];
        this.getConnection().removeNotificationListener(this.getTargetObjectName(), listener, filter, handback);
    }

    static {
        $assertionsDisabled = !AMXProxyHandler.class.desiredAssertionStatus();
        STRING = String.class.getName();
        EMPTY_SIG = new String[0];
        STRING_SIG = new String[]{STRING};
        STRING2_SIG = new String[]{STRING, STRING};
        GET_SINGLETON_CONTAINEE_OBJECT_NAME_SIG1 = STRING_SIG;
        GET_SINGLETON_CONTAINEE_OBJECT_NAME_SIG2 = STRING2_SIG;
        GET_OBJECT_NAMES_SIG_EMPTY = EMPTY_SIG;
        GET_OBJECT_NAMES_SIG_STRING = STRING_SIG;
        NOTIFICATION_LISTENER_SIG1 = new Class[]{NotificationListener.class};
        NOTIFICATION_LISTENER_SIG2 = new Class[]{NotificationListener.class, NotificationFilter.class, Object.class};
        CACHED_ATTRIBUTE_NAMES = Collections.unmodifiableSet(SetUtil.newSet(new String[]{"MBeanInfoIsInvariant", "InterfaceName", "Group", "FullType", CONTAINEE_J2EE_TYPES}));
        SPECIAL_METHOD_NAMES = Collections.unmodifiableSet(SetUtil.newSet(new String[]{GET_MBEAN_INFO, GET_J2EE_TYPE, GET_J2EE_NAME, GET_ATTRIBUTE_NAMES, GET_CONTAINER, GET_DOMAIN_ROOT, GET_OBJECT_NAME, GET_EXTRA, GET_ALL_ATTRIBUTES, ADD_NOTIFICATION_LISTENER, REMOVE_NOTIFICATION_LISTENER, "hashCode"}));
    }
}

