/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.base;

import com.sun.appserv.management.base.MapCapable;
import com.sun.appserv.management.util.jmx.OpenMBeanUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class MapCapableBase
implements MapCapable {
    private Map mFields = new HashMap();
    private boolean mWasMadeImmutable = false;
    private String mClassName;

    protected MapCapableBase(String className) {
        this.mClassName = className;
    }

    protected MapCapableBase(Map m, String className) {
        this(className);
        this.mClassName = className;
        if (m != null) {
            this.putAll(m);
            this.getFields().remove("MapCapableClassName");
        }
    }

    protected static void checkValidType(Map m, String requiredType) {
        String type = (String)m.get("MapCapableClassName");
        if (!requiredType.equals(type)) {
            throw new IllegalArgumentException("Illegal MAP_CAPABLE_CLASS_NAME_KEY: " + type);
        }
    }

    protected abstract boolean validate();

    public String getMapClassName() {
        return this.mClassName;
    }

    protected void illegalObject(Object o) {
        throw new IllegalArgumentException("Object is of illegal class " + o.getClass().getName());
    }

    protected void checkInJavaUtil(Object o) {
        if (!o.getClass().getName().startsWith("java.util.")) {
            this.illegalObject(o);
        }
    }

    protected final void checkLegalObject(Object o, boolean allowMapCapable) {
        if (o != null) {
            if (o instanceof Collection) {
                this.checkInJavaUtil(o);
                Iterator iter = ((Collection)o).iterator();
                while (iter.hasNext()) {
                    this.checkLegalObject(iter.next());
                }
            } else if (o.getClass().getComponentType() != null) {
                int length = Array.getLength(o);
                for (int i = 0; i < length; ++i) {
                    this.checkLegalObject(Array.get(o, i));
                }
            } else if (o instanceof MapCapable) {
                if (allowMapCapable) {
                    this.checkLegalObject(((MapCapable)o).asMap());
                } else {
                    this.illegalObject(o);
                }
            } else if (o instanceof Map) {
                this.checkInJavaUtil(o);
                this.checkLegalObject(((Map)o).keySet());
                this.checkLegalObject(((Map)o).values());
            } else if (o instanceof Throwable) {
                String classname = o.getClass().getName();
                if (!classname.startsWith("java.") && !classname.startsWith("javax.")) {
                    this.illegalObject(o);
                }
                this.checkLegalObject(((Throwable)o).getCause());
            } else if (OpenMBeanUtil.getSimpleType(o.getClass()) == null) {
                this.illegalObject(o);
            }
        }
    }

    protected final void checkLegalObject(Object o) {
        this.checkLegalObject(o, true);
    }

    protected boolean validateNullOrOfType(String key, Class theClass) {
        Object o = this.getField(key);
        return o == null || theClass.isAssignableFrom(o.getClass());
    }

    protected final void validateThrow() {
        if (!this.validate()) {
            throw new IllegalArgumentException(this.toString());
        }
    }

    public final Map asMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator iter = this.getFields().keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = this.getField(key);
            if (value instanceof MapCapable) {
                value = ((MapCapable)value).asMap();
            }
            result.put(key, value);
        }
        result.put("MapCapableClassName", this.getMapClassName());
        this.checkLegalObject(result, false);
        return result;
    }

    public void makeImmutable() {
        if (!this.mWasMadeImmutable) {
            this.mFields = Collections.unmodifiableMap(this.mFields);
            this.mWasMadeImmutable = true;
        }
    }

    public void putField(String key, Object value) {
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("" + key);
        }
        this.checkLegalObject(value);
        Object newValue = this.putFieldHook(key, value);
        this.getFields().put(key, newValue);
    }

    protected Object putFieldHook(String key, Object value) {
        return value;
    }

    protected void putAll(Map m) {
        if (m != null) {
            Iterator iter = m.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                this.putField(key, m.get(key));
            }
        }
    }

    private Map getFields() {
        return this.mFields;
    }

    protected Object getField(String key) {
        return this.getFields().get(key);
    }

    protected final Object getObject(String key) {
        return this.getFields().get(key);
    }

    protected final String getString(String key) {
        return (String)this.getObject(key);
    }

    protected final String[] getStringArray(String key) {
        return (String[])this.getObject(key);
    }

    protected final Boolean getBoolean(String key) {
        return (Boolean)this.getObject(key);
    }

    protected final Byte getByte(String key) {
        return (Byte)this.getObject(key);
    }

    protected final boolean getboolean(String key) {
        Boolean b = this.getBoolean(key);
        if (b == null) {
            throw new IllegalArgumentException(key);
        }
        return b;
    }

    protected final Integer getInteger(String key) {
        return (Integer)this.getObject(key);
    }

    protected final Map getMap(String key) {
        return (Map)this.getObject(key);
    }

    protected final File getFile(String key) {
        String s = this.getString(key);
        return s == null ? null : new File(s);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapCapableBase)) {
            return false;
        }
        boolean equals = false;
        MapCapableBase rhs = (MapCapableBase)o;
        equals = MapUtil.mapsEqual(this.getFields(), rhs.getFields());
        return equals;
    }

    public String toString() {
        return MapUtil.toString(this.getFields());
    }
}

