/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.utility;

import com.sun.jdo.spi.persistence.support.sqlstore.utility.StringScanner;

public class HexConverter {
    private static final int AFTER_POS = 13;
    private static final int HEX_START = 15;
    private static final int WORDS_PER_LINE = 4;
    private static final int CHARS_PER_WORD = 10;
    private static final int CHAR_START = 56;

    public static String simpleFormatHexBytes(byte[] rawBytes, int length) {
        String result = new String();
        for (int i = 0; i < length; ++i) {
            long data = rawBytes[i] & 0xFF;
            if (i > 0) {
                result = result.concat(" ");
            }
            if (Long.toHexString(data).length() == 1) {
                result = result.concat("0");
            }
            result = result.concat(Long.toHexString(data));
        }
        result = result.concat("\n");
        return result;
    }

    public static String formatHexBytes(byte[] rawBytes, int length) {
        int j;
        char[] buf = new char[100];
        int word = 0;
        int startPos = 0;
        String resultString = new String();
        for (j = 0; j < 100; ++j) {
            buf[j] = 32;
        }
        for (int i = 0; i < length; i += 4) {
            int bufPtr = word * 10 + 15;
            String dataAsHex = new String();
            for (j = 0; j < 4; ++j) {
                long data;
                try {
                    data = rawBytes[i + j] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    data = 0L;
                }
                if (Long.toHexString(data).length() == 1) {
                    dataAsHex = dataAsHex.concat("0");
                }
                dataAsHex = dataAsHex.concat(Long.toHexString(data));
            }
            for (j = 0; j < 8; ++j) {
                buf[bufPtr + j] = dataAsHex.charAt(j);
            }
            bufPtr = 56 + word * 4;
            for (j = 0; j < 4; ++j) {
                try {
                    if (Character.isLetterOrDigit((char)rawBytes[i + j])) {
                        buf[bufPtr + j] = (char)rawBytes[i + j];
                        continue;
                    }
                    buf[bufPtr + j] = 46;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    buf[bufPtr + j] = 95;
                }
            }
            if (i == 0 || ++word % 4 != 0) continue;
            HexConverter.overlayOffsets(buf, startPos);
            startPos = i + 4;
            resultString = resultString.concat(new String(buf, 0, 56 + word * 5));
            resultString = resultString.concat("\n");
            word = 0;
            for (j = 0; j < 100; ++j) {
                buf[j] = 32;
            }
        }
        if (word != 0) {
            HexConverter.overlayOffsets(buf, startPos);
            resultString = resultString.concat(new String(buf, 0, 56 + word * 5));
        }
        resultString = resultString.concat("\n");
        return resultString;
    }

    private static void overlayOffsets(char[] buf, int startPos) {
        int j;
        String startStr = StringScanner.getIntStr(startPos);
        String startStrHex = Integer.toHexString(startPos);
        for (j = 0; j < 6; ++j) {
            buf[j] = j + startStr.length() >= 6 ? startStr.charAt(startStr.length() - (6 - j)) : (char)32;
        }
        buf[6] = 32;
        buf[7] = 48;
        buf[8] = 120;
        for (j = 0; j < 4; ++j) {
            buf[j + 9] = j + startStrHex.length() >= 4 ? startStrHex.charAt(startStrHex.length() - (4 - j)) : (char)48;
        }
    }
}

