/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.database.DBVendorType;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.UpdateObjectDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.ColumnRef;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.DBStatement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryTable;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.Statement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.UpdateQueryPlan;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UpdateStatement
extends Statement
implements Cloneable {
    public int minAffectedRows;
    private Map dbStatementCache = new HashMap();
    UpdateQueryPlan plan;
    private List columnRefsForWhereClause;
    private boolean batch = false;
    private StringBuffer values;
    private boolean isConstraintAdded;

    public UpdateStatement(DBVendorType vendorType, UpdateQueryPlan plan, boolean batch) {
        super(vendorType);
        this.plan = plan;
        this.columnRefsForWhereClause = new ArrayList();
        this.batch = batch;
        this.minAffectedRows = 1;
    }

    public void addColumn(ColumnElement columnElement, Object value) {
        this.addColumnRef(new ColumnRef(columnElement, value));
    }

    protected void addConstraint(ColumnElement columnElement, LocalFieldDesc lf, Object value) {
        this.columnRefsForWhereClause.add(new ColumnRef(columnElement, value));
        this.addConstraint(lf, value);
    }

    private void calculateWhereClauseColumnRefIndexes() {
        int nextIndex = this.columns.size() + this.columnRefsForWhereClause.size();
        Iterator i = this.columnRefsForWhereClause.iterator();
        while (i.hasNext()) {
            ColumnRef columnRef = (ColumnRef)i.next();
            columnRef.setIndex(nextIndex--);
        }
    }

    public boolean isConstraintAdded() {
        return this.isConstraintAdded;
    }

    public void markConstraintAdded() {
        this.isConstraintAdded = true;
    }

    public QueryPlan getQueryPlan() {
        return this.plan;
    }

    protected void generateStatementText() {
        this.statementText = new StringBuffer();
        StringBuffer columnList = this.generateColumnText();
        StringBuffer constraint = this.processConstraints();
        String tableName = ((QueryTable)this.tableList.get(0)).getTableDesc().getName();
        switch (this.action) {
            case 1: {
                this.statementText.append("update ").append(this.quoteCharStart).append(tableName).append(this.quoteCharEnd).append(" set ").append(columnList).append(" where ").append(constraint);
                break;
            }
            case 3: {
                this.statementText.append("delete from ").append(this.quoteCharStart).append(tableName).append(this.quoteCharEnd).append(" where ").append(constraint);
                break;
            }
            case 2: {
                this.statementText.append("insert into ").append(this.quoteCharStart).append(tableName).append(this.quoteCharEnd).append("(").append(columnList).append(") values ").append("(").append(this.values).append(")");
            }
        }
        this.calculateWhereClauseColumnRefIndexes();
    }

    private StringBuffer generateColumnText() {
        StringBuffer columnList = new StringBuffer();
        int numValues = -1;
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnRef c = (ColumnRef)this.columns.get(i);
            if (columnList.length() > 0) {
                columnList.append(", ");
            }
            switch (this.action) {
                case 1: {
                    columnList.append(this.quoteCharStart);
                    columnList.append(c.getName());
                    columnList.append(this.quoteCharEnd);
                    columnList.append("= ?");
                    break;
                }
                case 2: {
                    columnList.append(this.quoteCharStart);
                    columnList.append(c.getName());
                    columnList.append(this.quoteCharEnd);
                    if (i == 0) {
                        this.values = new StringBuffer().append(" ?");
                        break;
                    }
                    this.values.append(", ?");
                }
            }
            if (this.batch || this.action != 1 && this.action != 2) continue;
            InputValue val = new InputValue(c.getValue(), c.getColumnElement());
            this.inputDesc.values.add(++numValues, val);
        }
        return columnList;
    }

    public void addLocalConstraints(int action, ForeignFieldDesc f, SQLStateManager sm) {
        for (int i = 0; i < f.localFields.size(); ++i) {
            LocalFieldDesc lf = (LocalFieldDesc)f.localFields.get(i);
            if (action == 2) {
                ColumnElement lc = (ColumnElement)f.assocLocalColumns.get(i);
                this.addColumn(lc, lf.getValue(sm));
                continue;
            }
            if (action != 3) continue;
            LocalFieldDesc alf = (LocalFieldDesc)f.assocLocalFields.get(i);
            this.addConstraint(alf, lf.getValue(sm));
        }
    }

    public void addForeignConstraints(int action, ForeignFieldDesc f, SQLStateManager sm) {
        for (int i = 0; i < f.foreignFields.size(); ++i) {
            LocalFieldDesc ff = (LocalFieldDesc)f.foreignFields.get(i);
            if (action == 2) {
                ColumnElement fc = (ColumnElement)f.assocForeignColumns.get(i);
                this.addColumn(fc, ff.getValue(sm));
                continue;
            }
            if (action != 3) continue;
            LocalFieldDesc aff = (LocalFieldDesc)f.assocForeignFields.get(i);
            this.addConstraint(aff, ff.getValue(sm));
        }
    }

    protected void processConstraintValue(ConstraintValue node, StringBuffer result) {
        result.append("?");
        if (!this.batch) {
            this.generateInputValueForConstraintValueNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBStatement getDBStatement(Transaction tran, Connection conn) throws SQLException {
        DBStatement dbStatement = null;
        Map map = this.dbStatementCache;
        synchronized (map) {
            dbStatement = (DBStatement)this.dbStatementCache.get(tran);
            if (dbStatement == null) {
                dbStatement = new DBStatement(conn, this.getText(), tran.getUpdateTimeout());
                this.dbStatementCache.put(tran, dbStatement);
            }
        }
        return dbStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exceedsBatchThreshold(Transaction tran) {
        Map map = this.dbStatementCache;
        synchronized (map) {
            DBStatement dbStatement = (DBStatement)this.dbStatementCache.get(tran);
            return dbStatement != null && dbStatement.exceedsBatchThreshold();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBStatement removeDBStatement(Transaction tran) {
        Map map = this.dbStatementCache;
        synchronized (map) {
            DBStatement s = (DBStatement)this.dbStatementCache.remove(tran);
            return s;
        }
    }

    public void bindInputColumns(DBStatement s, UpdateObjectDescImpl updateDesc) throws SQLException {
        Iterator i = this.getColumnRefs().iterator();
        while (i.hasNext()) {
            this.bindInputColumn(s, (ColumnRef)i.next(), updateDesc, false);
        }
        i = this.columnRefsForWhereClause.iterator();
        while (i.hasNext()) {
            this.bindInputColumn(s, (ColumnRef)i.next(), updateDesc, updateDesc.isBeforeImageRequired());
        }
    }

    private void bindInputColumn(DBStatement stmt, ColumnRef columnRef, UpdateObjectDescImpl updateDesc, boolean getBeforeValue) throws SQLException {
        Object inputValue = UpdateStatement.getInputValue(updateDesc, columnRef, getBeforeValue);
        stmt.bindInputColumn(columnRef.getIndex(), inputValue, columnRef.getColumnElement(), this.vendorType);
    }

    private Object[] getInputValues(UpdateObjectDescImpl updateDesc) {
        Object[] inputValues = new Object[this.getColumnRefs().size() + this.columnRefsForWhereClause.size()];
        Iterator i = this.getColumnRefs().iterator();
        while (i.hasNext()) {
            ColumnRef columnRef = (ColumnRef)i.next();
            inputValues[columnRef.getIndex() - 1] = UpdateStatement.getInputValue(updateDesc, columnRef, false);
        }
        boolean getBeforeValue = updateDesc.isBeforeImageRequired();
        Iterator i2 = this.columnRefsForWhereClause.iterator();
        while (i2.hasNext()) {
            ColumnRef columnRef = (ColumnRef)i2.next();
            inputValues[columnRef.getIndex() - 1] = UpdateStatement.getInputValue(updateDesc, columnRef, getBeforeValue);
        }
        return inputValues;
    }

    public String getFormattedSQLText(UpdateObjectDescImpl updateDesc) {
        return UpdateStatement.formatSqlText(this.getText(), this.getInputValues(updateDesc));
    }

    private static Object getInputValue(UpdateObjectDescImpl updateDesc, ColumnRef columnRef, boolean getBeforeValue) {
        LocalFieldDesc field = (LocalFieldDesc)columnRef.getValue();
        Object value = field.isVersion() ? updateDesc.getAfterValue(field) : (getBeforeValue ? updateDesc.getBeforeValue(field) : updateDesc.getAfterValue(field));
        return value;
    }
}

