/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sco;

import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.SCOCollection;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;

public class HashSet
extends java.util.HashSet
implements SCOCollection {
    private transient PersistenceCapable owner;
    private transient String fieldName;
    private transient Class elementType;
    private transient boolean allowNulls;
    private transient java.util.HashSet added = new java.util.HashSet();
    private transient java.util.HashSet removed = new java.util.HashSet();
    private transient boolean isDeferred;
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.impl.Bundle", HashSet.class.getClassLoader());
    private static final ResourceBundle messages1 = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", HashSet.class.getClassLoader());

    public HashSet(Object owner, String fieldName, Class elementType, boolean allowNulls) {
        if (owner instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)owner;
            this.fieldName = fieldName;
        }
        this.elementType = elementType;
        this.allowNulls = allowNulls;
    }

    public HashSet(Object owner, String fieldName, Class elementType, boolean allowNulls, int initialCapacity) {
        super(initialCapacity);
        if (owner instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)owner;
            this.fieldName = fieldName;
        }
        this.elementType = elementType;
        this.allowNulls = allowNulls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        StateManager stateManager;
        if (!this.allowNulls && o == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        if (this.elementType != null && !this.elementType.isAssignableFrom(o.getClass())) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{o});
        }
        if (this.owner != null && (stateManager = this.owner.jdoGetStateManager()) != null) {
            PersistenceManager pm = (PersistenceManager)stateManager.getPersistenceManagerInternal();
            pm.acquireShareLock();
            boolean modified = false;
            try {
                pm.acquireFieldUpdateLock();
                try {
                    stateManager.makeDirty(this.fieldName);
                    modified = super.add(o);
                    if (modified) {
                        if (!this.removed.remove(o)) {
                            this.added.add(o);
                        }
                        stateManager.applyUpdates(this.fieldName, this);
                    }
                    boolean bl = modified;
                    pm.releaseFieldUpdateLock();
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        pm.releaseFieldUpdateLock();
                        throw throwable;
                    }
                    catch (JDOUserException e) {
                        Object[] failedObjects = e.getFailedObjectArray();
                        if (modified && failedObjects != null) {
                            for (int i = 0; i < failedObjects.length; ++i) {
                                Object failedObject = failedObjects[i];
                                if (failedObject != o) continue;
                                super.remove(failedObject);
                                break;
                            }
                        }
                        throw e;
                    }
                }
            }
            finally {
                pm.releaseShareLock();
            }
        }
        return super.add(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c) {
        StateManager stateManager;
        if (!this.allowNulls && c.contains(null)) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        ArrayList errc = new ArrayList();
        if (this.elementType != null) {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (this.elementType.isAssignableFrom(o.getClass())) continue;
                errc.add(o);
            }
        }
        if (errc != null && errc.size() > 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), errc.toArray());
        }
        boolean modified = false;
        if (this.owner != null && (stateManager = this.owner.jdoGetStateManager()) != null) {
            PersistenceManager pm = (PersistenceManager)stateManager.getPersistenceManagerInternal();
            pm.acquireShareLock();
            try {
                pm.acquireFieldUpdateLock();
                try {
                    stateManager.makeDirty(this.fieldName);
                    Iterator iter22 = c.iterator();
                    while (iter22.hasNext()) {
                        Object o = iter22.next();
                        if (super.contains(o)) continue;
                        if (!this.removed.remove(o)) {
                            this.added.add(o);
                        }
                        super.add(o);
                        modified = true;
                    }
                    if (modified) {
                        stateManager.applyUpdates(this.fieldName, this);
                    }
                    boolean iter22 = modified;
                    pm.releaseFieldUpdateLock();
                    return iter22;
                }
                catch (Throwable throwable) {
                    try {
                        pm.releaseFieldUpdateLock();
                        throw throwable;
                    }
                    catch (JDOUserException e) {
                        Object[] failedObjects = e.getFailedObjectArray();
                        if (modified && failedObjects != null) {
                            for (int i = 0; i < failedObjects.length; ++i) {
                                super.remove(failedObjects[i]);
                            }
                        }
                        throw e;
                    }
                }
            }
            finally {
                pm.releaseShareLock();
            }
        }
        return super.addAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        StateManager stateManager;
        if (this.owner != null && (stateManager = this.owner.jdoGetStateManager()) != null) {
            PersistenceManager pm = (PersistenceManager)stateManager.getPersistenceManagerInternal();
            pm.acquireShareLock();
            try {
                pm.acquireFieldUpdateLock();
                try {
                    stateManager.makeDirty(this.fieldName);
                    boolean modified = super.remove(o);
                    if (modified) {
                        if (!this.added.remove(o)) {
                            this.removed.add(o);
                        }
                        stateManager.applyUpdates(this.fieldName, this);
                    }
                    boolean bl = modified;
                    pm.releaseFieldUpdateLock();
                    return bl;
                }
                catch (Throwable throwable) {
                    pm.releaseFieldUpdateLock();
                    throw throwable;
                }
            }
            finally {
                pm.releaseShareLock();
            }
        }
        return super.remove(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection c) {
        StateManager stateManager;
        if (this.owner != null && (stateManager = this.owner.jdoGetStateManager()) != null) {
            PersistenceManager pm = (PersistenceManager)stateManager.getPersistenceManagerInternal();
            pm.acquireShareLock();
            try {
                pm.acquireFieldUpdateLock();
                try {
                    stateManager.makeDirty(this.fieldName);
                    Iterator iter = c.iterator();
                    while (iter.hasNext()) {
                        Object o = iter.next();
                        if (!super.contains(o) || this.added.remove(o)) continue;
                        this.removed.add(o);
                    }
                    boolean modified = super.removeAll(c);
                    if (modified) {
                        stateManager.applyUpdates(this.fieldName, this);
                    }
                    boolean bl = modified;
                    pm.releaseFieldUpdateLock();
                    return bl;
                }
                catch (Throwable throwable) {
                    pm.releaseFieldUpdateLock();
                    throw throwable;
                }
            }
            finally {
                pm.releaseShareLock();
            }
        }
        return super.removeAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection c) {
        StateManager stateManager;
        if (this.owner != null && (stateManager = this.owner.jdoGetStateManager()) != null) {
            PersistenceManager pm = (PersistenceManager)stateManager.getPersistenceManagerInternal();
            pm.acquireShareLock();
            try {
                pm.acquireFieldUpdateLock();
                try {
                    stateManager.makeDirty(this.fieldName);
                    Iterator iter = super.iterator();
                    while (iter.hasNext()) {
                        Object o = iter.next();
                        if (c.contains(o) || this.added.remove(o)) continue;
                        this.removed.add(o);
                    }
                    boolean modified = super.retainAll(c);
                    if (modified) {
                        stateManager.applyUpdates(this.fieldName, this);
                    }
                    boolean bl = modified;
                    pm.releaseFieldUpdateLock();
                    return bl;
                }
                catch (Throwable throwable) {
                    pm.releaseFieldUpdateLock();
                    throw throwable;
                }
            }
            finally {
                pm.releaseShareLock();
            }
        }
        return super.retainAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        StateManager stateManager;
        if (this.owner != null && (stateManager = this.owner.jdoGetStateManager()) != null) {
            PersistenceManager pm = (PersistenceManager)stateManager.getPersistenceManagerInternal();
            pm.acquireShareLock();
            try {
                pm.acquireFieldUpdateLock();
                try {
                    stateManager.makeDirty(this.fieldName);
                    this.removed.clear();
                    this.added.clear();
                    Iterator iter = super.iterator();
                    while (iter.hasNext()) {
                        this.removed.add(iter.next());
                    }
                    super.clear();
                    stateManager.applyUpdates(this.fieldName, this);
                    pm.releaseFieldUpdateLock();
                    return;
                }
                catch (Throwable throwable) {
                    pm.releaseFieldUpdateLock();
                    throw throwable;
                }
            }
            finally {
                pm.releaseShareLock();
            }
        }
        super.clear();
    }

    public Object clone() {
        HashSet obj = (HashSet)super.clone();
        obj.unsetOwner();
        return obj;
    }

    public Iterator iterator() {
        return new SCOHashIterator(super.iterator(), this);
    }

    public Object cloneInternal() {
        return super.clone();
    }

    public void reset() {
        if (this.added != null) {
            this.added.clear();
        }
        if (this.removed != null) {
            this.removed.clear();
        }
    }

    public void markDeferred() {
        this.isDeferred = true;
    }

    public boolean isDeferred() {
        return this.isDeferred;
    }

    public void applyDeferredUpdates(Collection c) {
        if (!this.isDeferred) {
            return;
        }
        this.isDeferred = false;
        this.addAllInternal(c);
        this.addAllInternal(this.added);
        this.removeAllInternal(this.removed);
        this.added.clear();
        this.removed.clear();
    }

    public void addInternal(Object o) {
        if (this.isDeferred) {
            if (!this.removed.remove(o)) {
                this.added.add(o);
            }
        } else {
            super.add(o);
        }
    }

    public void addAllInternal(Collection c) {
        if (c == null) {
            return;
        }
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.addInternal(iter.next());
        }
    }

    public void addToBaseCollection(Object o) {
        super.add(o);
    }

    public void removeAllInternal(Collection c) {
        if (c == null) {
            return;
        }
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.removeInternal(iter.next());
        }
    }

    public Collection getAdded() {
        return this.added;
    }

    public Collection getRemoved() {
        return this.removed;
    }

    public void clearInternal() {
        super.clear();
        this.reset();
    }

    public void removeInternal(Object o) {
        if (this.isDeferred) {
            if (!this.added.remove(o)) {
                this.removed.add(o);
            }
        } else {
            super.remove(o);
        }
    }

    public void unsetOwner() {
        this.owner = null;
        this.fieldName = null;
        this.elementType = null;
        this.added.clear();
        this.removed.clear();
    }

    public Object getOwner() {
        return this.owner;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public StateManager makeDirty() {
        StateManager stateManager = this.owner.jdoGetStateManager();
        if (stateManager != null) {
            stateManager.makeDirty(this.fieldName);
        }
        return stateManager;
    }

    public void applyUpdates(StateManager sm, boolean modified) {
        if (modified && sm != null) {
            sm.applyUpdates(this.fieldName, this);
        }
    }

    public void setOwner(Object owner, String fieldName, Class elementType) {
        if (this.owner != null) {
            throw new JDOUserException(I18NHelper.getMessage(messages1, "core.statemanager.anotherowner"), new Object[]{this.owner, this.fieldName});
        }
        if (owner instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)owner;
            this.fieldName = fieldName;
            this.elementType = elementType;
        }
    }

    private class SCOHashIterator
    implements Iterator {
        Iterator _iterator = null;
        HashSet _caller = null;
        Object lastReturned = null;

        SCOHashIterator(Iterator it, HashSet cl) {
            this._iterator = it;
            this._caller = cl;
        }

        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        public Object next() {
            this.lastReturned = this._iterator.next();
            return this.lastReturned;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (this._caller.owner != null) {
                StateManager stateManager = this._caller.owner.jdoGetStateManager();
                if (stateManager != null) {
                    PersistenceManager pm = (PersistenceManager)stateManager.getPersistenceManagerInternal();
                    pm.acquireShareLock();
                    try {
                        pm.acquireFieldUpdateLock();
                        try {
                            stateManager.makeDirty(this._caller.fieldName);
                            this._iterator.remove();
                            if (!HashSet.this.added.remove(this.lastReturned)) {
                                HashSet.this.removed.add(this.lastReturned);
                            }
                            stateManager.applyUpdates(this._caller.fieldName, this._caller);
                        }
                        finally {
                            pm.releaseFieldUpdateLock();
                        }
                    }
                    finally {
                        pm.releaseShareLock();
                    }
                }
            } else {
                this._iterator.remove();
            }
            this.lastReturned = null;
        }
    }
}

