/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sco;

import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.SCOCollection;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;

public class ArrayList
extends java.util.ArrayList
implements SCOCollection {
    private transient PersistenceCapable owner;
    private transient String fieldName;
    private transient Class elementType;
    private transient boolean allowNulls;
    private transient Vector added = new Vector();
    private transient Vector removed = new Vector();
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.impl.Bundle", ArrayList.class.getClassLoader());
    private static final ResourceBundle messages1 = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", ArrayList.class.getClassLoader());

    public ArrayList(Object owner, String fieldName, Class elementType, boolean allowNulls) {
        if (owner instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)owner;
            this.fieldName = fieldName;
        }
        this.elementType = elementType;
        this.allowNulls = allowNulls;
    }

    public ArrayList(Object owner, String fieldName, Class elementType, boolean allowNulls, int initialCapacity) {
        super(initialCapacity);
        if (owner instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)owner;
            this.fieldName = fieldName;
        }
        this.elementType = elementType;
        this.allowNulls = allowNulls;
    }

    public Object set(int index, Object element) {
        this.throwUnsupportedOption();
        if (element == null) {
            if (!this.allowNulls) {
                throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
            }
            return this.remove(index);
        }
        if (this.elementType == null || this.elementType.isAssignableFrom(element.getClass())) {
            StateManager stateManager = this.makeDirty();
            Object o = super.set(index, element);
            if (!this.added.remove(o)) {
                this.removed.add(o);
            }
            if (!this.removed.remove(element)) {
                this.added.add(element);
            }
            this.applyUpdates(stateManager, true);
            return o;
        }
        throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{element});
    }

    public boolean add(Object o) {
        if (!this.allowNulls && o == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        if (this.elementType == null || this.elementType.isAssignableFrom(o.getClass())) {
            StateManager stateManager = this.makeDirty();
            if (!this.removed.remove(o)) {
                this.added.add(o);
            }
            boolean modified = super.add(o);
            this.applyUpdates(stateManager, modified);
            return modified;
        }
        throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{o});
    }

    public boolean remove(Object o) {
        StateManager stateManager = this.makeDirty();
        int i = super.indexOf(o);
        Object obj = null;
        if (i > -1) {
            obj = super.remove(i);
            if (!this.added.remove(obj)) {
                this.removed.add(obj);
            }
            this.applyUpdates(stateManager, true);
            return true;
        }
        return false;
    }

    public void add(int index, Object element) {
        StateManager stateManager;
        if (!this.allowNulls && element == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        if (this.elementType == null || this.elementType.isAssignableFrom(element.getClass())) {
            stateManager = this.makeDirty();
            super.add(index, element);
            if (!this.removed.remove(element)) {
                this.added.add(element);
            }
        } else {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{element});
        }
        this.applyUpdates(stateManager, true);
    }

    public Object remove(int index) {
        this.throwUnsupportedOption();
        StateManager stateManager = this.makeDirty();
        Object obj = super.remove(index);
        if (!this.added.remove(obj)) {
            this.removed.add(obj);
        }
        this.applyUpdates(stateManager, true);
        return obj;
    }

    public void clear() {
        StateManager stateManager = this.makeDirty();
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (this.added.remove(o)) continue;
            this.removed.add(o);
        }
        this.added.clear();
        super.clear();
        this.applyUpdates(stateManager, true);
    }

    public boolean addAll(Collection c) {
        if (!this.allowNulls && c.contains(null)) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        Vector errc = new Vector();
        if (this.elementType != null) {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (this.elementType.isAssignableFrom(o.getClass())) continue;
                errc.add(o);
            }
        }
        if (errc != null && errc.size() > 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), errc.toArray());
        }
        StateManager stateManager = this.makeDirty();
        this.removed.removeAll(c);
        this.added.addAll(c);
        boolean modified = super.addAll(c);
        this.applyUpdates(stateManager, modified);
        return modified;
    }

    public boolean removeAll(Collection c) {
        boolean modified = false;
        StateManager stateManager = this.makeDirty();
        Iterator e = c.iterator();
        while (e.hasNext()) {
            Object o = e.next();
            if (!super.contains(o)) continue;
            this.removeInternal(o);
            if (!this.added.remove(o)) {
                this.removed.add(o);
            }
            modified = true;
        }
        this.applyUpdates(stateManager, modified);
        return modified;
    }

    public boolean addAll(int index, Collection c) {
        if (!this.allowNulls && c.contains(null)) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        Vector errc = new Vector();
        if (this.elementType != null) {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (this.elementType.isAssignableFrom(o.getClass())) continue;
                errc.add(o);
            }
        }
        if (errc != null && errc.size() > 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), errc.toArray());
        }
        StateManager stateManager = this.makeDirty();
        this.removed.removeAll(c);
        this.added.addAll(c);
        boolean modified = super.addAll(index, c);
        this.applyUpdates(stateManager, modified);
        return modified;
    }

    public boolean retainAll(Collection c) {
        boolean modified = false;
        Vector v = new Vector();
        StateManager stateManager = this.makeDirty();
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (c.contains(o)) continue;
            v.add(o);
            if (!this.added.remove(o)) {
                this.removed.add(o);
            }
            modified = true;
        }
        iter = v.iterator();
        while (iter.hasNext()) {
            this.removeInternal(iter.next());
        }
        this.applyUpdates(stateManager, modified);
        return modified;
    }

    public Object clone() {
        ArrayList obj = (ArrayList)super.clone();
        obj.unsetOwner();
        return obj;
    }

    public Object cloneInternal() {
        return super.clone();
    }

    public void reset() {
        this.added.clear();
        this.removed.clear();
    }

    public void markDeferred() {
    }

    public boolean isDeferred() {
        return false;
    }

    public void applyDeferredUpdates(Collection c) {
        super.addAll(c);
    }

    public void addInternal(Object o) {
        super.add(o);
    }

    public void addAllInternal(Collection c) {
        super.addAll(c);
    }

    public void addToBaseCollection(Object o) {
        super.add(o);
    }

    public void removeAllInternal(Collection c) {
        super.removeAll(c);
    }

    public Collection getAdded() {
        return this.added;
    }

    public Collection getRemoved() {
        return this.removed;
    }

    public void clearInternal() {
        super.clear();
        this.reset();
    }

    public void removeInternal(Object o) {
        int i = super.indexOf(o);
        super.remove(i);
    }

    public void unsetOwner() {
        this.owner = null;
        this.fieldName = null;
        this.elementType = null;
        this.added.clear();
        this.removed.clear();
    }

    public Object getOwner() {
        return this.owner;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public StateManager makeDirty() {
        if (this.owner != null) {
            StateManager stateManager = this.owner.jdoGetStateManager();
            if (stateManager != null) {
                stateManager.makeDirty(this.fieldName);
            }
            return stateManager;
        }
        return null;
    }

    public void applyUpdates(StateManager sm, boolean modified) {
        if (modified && sm != null) {
            sm.applyUpdates(this.fieldName, this);
        }
    }

    private void throwUnsupportedOption() {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "sco.not_supported"));
    }

    public void setOwner(Object owner, String fieldName, Class elementType) {
        if (this.owner != null) {
            throw new JDOUserException(I18NHelper.getMessage(messages1, "core.statemanager.anotherowner"), new Object[]{this.owner, this.fieldName});
        }
        if (owner instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)owner;
            this.fieldName = fieldName;
            this.elementType = elementType;
        }
    }
}

