/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.util.type;

import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.FieldInfo;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.Type;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.TypeTable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassType
extends Type {
    protected TypeTable typetab;
    protected Map fieldInfos;
    protected PersistenceClassElement pce;

    public ClassType(String name, Class clazz, int enumType, TypeTable typetab) {
        super(name, clazz, enumType);
        this.typetab = typetab;
        this.fieldInfos = new HashMap();
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            try {
                this.pce = typetab.model.getPersistenceClass(name, classLoader);
            }
            catch (IllegalArgumentException ex) {
                throw new JDOFatalUserException(ex.getMessage());
            }
        }
    }

    public ClassType(String name, Class clazz, TypeTable typetab) {
        this(name, clazz, 0, typetab);
    }

    public boolean isCompatibleWith(Type type) {
        boolean result = false;
        if (type instanceof ClassType) {
            result = ((ClassType)type).clazz.isAssignableFrom(this.clazz);
        }
        return result;
    }

    public boolean isOrderable() {
        Type comparable = this.typetab.checkType("java.lang.Comparable");
        return this.isCompatibleWith(comparable);
    }

    public boolean isPersistenceCapable() {
        return this.pce != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfo[] getFieldInfos() {
        final Class cl = this.clazz;
        Field[] fields = (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cl.getDeclaredFields();
            }
        });
        Map map = this.fieldInfos;
        synchronized (map) {
            for (int i = 0; i < fields.length; ++i) {
                String fieldName = fields[i].getName();
                FieldInfo fieldInfo = (FieldInfo)this.fieldInfos.get(fieldName);
                if (fieldInfo != null) continue;
                this.fieldInfos.put(fieldName, new FieldInfo(fields[i], this));
            }
        }
        return this.fieldInfos.values().toArray(new FieldInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfo getFieldInfo(String fieldName) {
        Map map = this.fieldInfos;
        synchronized (map) {
            Class cl;
            Field field;
            FieldInfo fieldInfo = (FieldInfo)this.fieldInfos.get(fieldName);
            if (fieldInfo == null && (field = (Field)AccessController.doPrivileged(new PrivilegedAction(cl = this.clazz, fieldName){
                private final /* synthetic */ Class val$cl;
                private final /* synthetic */ String val$fieldName;
                {
                    this.val$cl = val$cl;
                    this.val$fieldName = val$fieldName;
                }

                public Object run() {
                    try {
                        return this.val$cl.getDeclaredField(this.val$fieldName);
                    }
                    catch (NoSuchFieldException ex) {
                        return null;
                    }
                }
            })) != null) {
                fieldInfo = new FieldInfo(field, this);
                this.fieldInfos.put(fieldName, fieldInfo);
            }
            return fieldInfo;
        }
    }

    public List getKeyFieldNames() {
        if (this.pce != null) {
            PersistenceFieldElement[] persistentFields = this.pce.getFields();
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < persistentFields.length; ++i) {
                if (!persistentFields[i].isKey()) continue;
                names.add(persistentFields[i].getName());
            }
            return names;
        }
        return null;
    }
}

