/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLAST;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class VariableTable {
    protected static final ResourceBundle messages = I18NHelper.loadBundle(VariableTable.class);
    private ErrorMsg errorMsg;
    private List declaredVars;
    private Map varInfos;

    public VariableTable(ErrorMsg errorMsg) {
        this.errorMsg = errorMsg;
        this.declaredVars = new ArrayList();
        this.varInfos = new HashMap();
    }

    public VariableTable(VariableTable other) {
        this.errorMsg = other.errorMsg;
        this.declaredVars = other.declaredVars;
        this.varInfos = new HashMap();
        Iterator i = other.varInfos.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.varInfos.put(entry.getKey(), new VarInfo((VarInfo)entry.getValue()));
        }
    }

    public void add(String name) {
        this.declaredVars.add(name);
        this.varInfos.put(name, new VarInfo());
    }

    public void markUsed(JQLAST variable, String dependendVar) {
        String name = variable.getText();
        VarInfo entry = (VarInfo)this.varInfos.get(name);
        if (entry == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "jqlc.variabletable.markused.varnotfound", name));
        }
        entry.used.add(variable);
        if (dependendVar != null) {
            VarInfo dependendVarInfo = (VarInfo)this.varInfos.get(dependendVar);
            if (dependendVarInfo.dependsOn != null) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "jqlc.variabletable.markused.multidep", dependendVar, dependendVarInfo.dependsOn, name));
            }
            dependendVarInfo.dependsOn = name;
        }
    }

    public void markConstraint(JQLAST variable, JQLAST expr) {
        String old;
        String name = variable.getText();
        VarInfo entry = (VarInfo)this.varInfos.get(name);
        if (entry == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "jqlc.variabletable.markconstraint.varnotfound", name));
        }
        String string = old = entry.constraint == null ? null : entry.constraint.getText();
        if (old != null && !old.equals(expr.getText())) {
            this.errorMsg.unsupported(variable.getLine(), variable.getColumn(), I18NHelper.getMessage(messages, "jqlc.variabletable.markconstraint.multiple", name));
        }
        entry.constraint = expr;
    }

    public void merge(VariableTable other) {
        Iterator i = this.declaredVars.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            VarInfo info = (VarInfo)this.varInfos.get(name);
            VarInfo otherInfo = (VarInfo)other.varInfos.get(name);
            if (info.constraint == null && info.used.size() == 0) {
                info.constraint = otherInfo.constraint;
                info.used = otherInfo.used;
                info.dependsOn = otherInfo.dependsOn;
                info.status = otherInfo.status;
                continue;
            }
            if (otherInfo.constraint == null && otherInfo.used.size() == 0) continue;
            if (info.constraint != null && otherInfo.constraint != null) {
                if (!otherInfo.constraint.getText().equals(info.constraint.getText())) {
                    throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jqlc.variabletable.merge.different", name));
                }
            } else {
                info.constraint = null;
                info.dependsOn = null;
                info.status = 0;
            }
            info.used.addAll(otherInfo.used);
        }
    }

    public void checkConstraints() {
        Iterator i = this.declaredVars.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            VarInfo info = (VarInfo)this.varInfos.get(name);
            this.checkConstraint(name, info);
        }
    }

    protected void checkConstraint(String variable, VarInfo info) {
        switch (info.status) {
            case 0: {
                info.status = 1;
                break;
            }
            case 1: {
                throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jqlc.variabletable.checkconstraint.cycle", variable));
            }
            case 2: {
                return;
            }
        }
        if (info.dependsOn != null) {
            VarInfo dependendVarInfo = (VarInfo)this.varInfos.get(info.dependsOn);
            this.checkConstraint(info.dependsOn, dependendVarInfo);
        }
        if (info.constraint != null && info.used.size() == 0) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jqlc.variabletable.checkconstraint.unused", variable));
        }
        this.attachConstraintToUsedAST(info);
        info.status = 2;
    }

    protected void attachConstraintToUsedAST(VarInfo info) {
        Iterator i = info.used.iterator();
        while (i.hasNext()) {
            JQLAST varNode = (JQLAST)i.next();
            if (varNode.getFirstChild() != null) continue;
            varNode.setFirstChild(JQLAST.Factory.getInstance().dupTree(info.constraint));
        }
    }

    static class VarInfo {
        JQLAST constraint;
        Set used;
        String dependsOn;
        int status;
        static final int UNCHECKED = 0;
        static final int IN_PROGRESS = 1;
        static final int CHECKED = 2;

        VarInfo() {
            this.constraint = null;
            this.used = new HashSet();
            this.dependsOn = null;
            this.status = 0;
        }

        VarInfo(VarInfo other) {
            this.constraint = other.constraint;
            this.used = new HashSet(other.used);
            this.dependsOn = other.dependsOn;
            this.status = other.status;
        }
    }
}

