/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

import antlr.ANTLRException;
import antlr.TokenBuffer;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOQueryException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.spi.persistence.support.sqlstore.ExtentCollection;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.CodeGeneration;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLAST;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLLexer;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLParser;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.LogHelperQueryCompilerJDO;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.Optimizer;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ParameterTable;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.Semantic;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.TypeTable;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class JQLC {
    protected TypeTable typetab;
    protected ErrorMsg errorMsg;
    protected Class candidateClass;
    protected JQLAST filterAST = null;
    protected JQLAST importsAST = null;
    protected JQLAST varsAST = null;
    protected JQLAST paramsAST = null;
    protected JQLAST orderingAST = null;
    protected JQLAST resultAST = null;
    protected JQLAST queryAST = null;
    private boolean prefetchEnabled;
    protected Map retrieveDescCache = new HashMap();
    protected static final ResourceBundle messages = I18NHelper.loadBundle(JQLC.class);
    private static Logger logger = LogHelperQueryCompilerJDO.getLogger();

    public JQLC() {
        this.errorMsg = new ErrorMsg();
    }

    public void setClass(Class candidateClass) {
        if (candidateClass == null) {
            JDOQueryException ex = new JDOQueryException(I18NHelper.getMessage(messages, "jqlc.jqlc.generic.nocandidateclass"));
            logger.throwing("jqlc.JQLC", "setClass", ex);
            throw ex;
        }
        this.candidateClass = candidateClass;
    }

    public void declareImports(String imports) {
        if (imports == null) {
            this.importsAST = null;
            return;
        }
        try {
            JQLParser parser = this.createStringParser(imports);
            parser.parseImports();
            this.importsAST = (JQLAST)parser.getAST();
        }
        catch (ANTLRException ex) {
            JQLParser.handleANTLRException(ex, this.errorMsg);
        }
    }

    public void declareParameters(String parameters) {
        if (parameters == null) {
            this.paramsAST = null;
            return;
        }
        try {
            JQLParser parser = this.createStringParser(parameters);
            parser.parseParameters();
            this.paramsAST = (JQLAST)parser.getAST();
        }
        catch (ANTLRException ex) {
            JQLParser.handleANTLRException(ex, this.errorMsg);
        }
    }

    public void declareVariables(String variables) {
        if (variables == null) {
            this.varsAST = null;
            return;
        }
        try {
            JQLParser parser = this.createStringParser(variables);
            parser.parseVariables();
            this.varsAST = (JQLAST)parser.getAST();
        }
        catch (ANTLRException ex) {
            JQLParser.handleANTLRException(ex, this.errorMsg);
        }
    }

    public void setOrdering(String ordering) {
        if (ordering == null) {
            this.orderingAST = null;
            return;
        }
        try {
            JQLParser parser = this.createStringParser(ordering);
            parser.parseOrdering();
            this.orderingAST = (JQLAST)parser.getAST();
        }
        catch (ANTLRException ex) {
            JQLParser.handleANTLRException(ex, this.errorMsg);
        }
    }

    public void setResult(String result) {
        if (result == null) {
            this.resultAST = null;
            return;
        }
        try {
            JQLParser parser = this.createStringParser(result);
            parser.parseResult();
            this.resultAST = (JQLAST)parser.getAST();
        }
        catch (ANTLRException ex) {
            JQLParser.handleANTLRException(ex, this.errorMsg);
        }
    }

    public void setFilter(String filter) {
        if (StringHelper.isEmpty(filter)) {
            filter = "true";
        }
        try {
            JQLParser parser = this.createStringParser(filter);
            parser.parseFilter();
            this.filterAST = (JQLAST)parser.getAST();
        }
        catch (ANTLRException ex) {
            JQLParser.handleANTLRException(ex, this.errorMsg);
        }
    }

    public void setPrefetchEnabled(boolean prefetchEnabled) {
        this.prefetchEnabled = prefetchEnabled;
    }

    public void semanticCheck(ParameterTable paramtab) {
        boolean finer = logger.isLoggable(400);
        boolean finest = logger.isLoggable(300);
        this.typetab = TypeTable.getInstance(this.candidateClass.getClassLoader());
        paramtab.init();
        Semantic semantic = new Semantic();
        semantic.init(this.typetab, paramtab, this.errorMsg);
        semantic.setASTFactory(JQLAST.Factory.getInstance());
        JQLAST classAST = semantic.checkCandidateClass(this.candidateClass);
        this.queryAST = semantic.createQueryAST(classAST, this.importsAST, this.paramsAST, this.varsAST, this.orderingAST, this.resultAST, this.filterAST);
        if (finest) {
            logger.finest("LOG_JQLCDumpTree", this.queryAST.getTreeRepr("(AST)"));
        }
        try {
            if (finer) {
                logger.finer("LOG_JQLCStartPass", "semantic analysis");
            }
            semantic.query(this.queryAST);
            this.queryAST = (JQLAST)semantic.getAST();
            if (finest) {
                logger.finest("LOG_JQLCDumpTree", this.queryAST.getTreeRepr("(typed AST)"));
            }
        }
        catch (ANTLRException ex) {
            this.errorMsg.fatal("JQLC.semanticCheck unexpected exception", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetrieveDesc codeGen(PersistenceManager pm, ParameterTable paramtab) {
        boolean finer = logger.isLoggable(400);
        boolean finest = logger.isLoggable(300);
        RetrieveDesc rd = null;
        String key = paramtab.getKeyForRetrieveDescCache();
        Map map = this.retrieveDescCache;
        synchronized (map) {
            if (key != null) {
                rd = (RetrieveDesc)this.retrieveDescCache.get(key);
            }
            if (rd == null) {
                Optimizer optimizer = new Optimizer();
                optimizer.init(this.typetab, paramtab, this.errorMsg);
                optimizer.setASTFactory(JQLAST.Factory.getInstance());
                CodeGeneration codeGen = new CodeGeneration();
                codeGen.init(pm, this.typetab, paramtab, this.errorMsg, this.prefetchEnabled);
                codeGen.setASTFactory(JQLAST.Factory.getInstance());
                try {
                    JQLAST ast = this.queryAST;
                    if (finer) {
                        logger.finer("LOG_JQLCStartPass", "optimizer");
                    }
                    optimizer.query(ast);
                    ast = (JQLAST)optimizer.getAST();
                    if (finest) {
                        logger.finest("LOG_JQLCDumpTree", ast.getTreeRepr("(optimized AST)"));
                    }
                    if (finer) {
                        logger.finer("LOG_JQLCStartPass", "code generation");
                    }
                    codeGen.query(ast);
                    rd = codeGen.getRetrieveDesc();
                    if (key != null) {
                        this.retrieveDescCache.put(key, rd);
                    }
                }
                catch (ANTLRException ex) {
                    this.errorMsg.fatal("JQLC.codeGen unexpected exception", ex);
                }
            } else if (finer) {
                logger.finest("LOG_JQLCReuseRetrieveDesc");
            }
        }
        return rd;
    }

    public void checkCandidates(Class candidateClass, Collection candidateCollection) {
        if (candidateClass == null) {
            throw new JDOQueryException(I18NHelper.getMessage(messages, "jqlc.jqlc.generic.nocandidateclass"));
        }
        if (!(candidateCollection instanceof ExtentCollection)) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jqlc.jqlc.checkcandidates.memorycollection"));
        }
        Class candidatePCClass = ((ExtentCollection)candidateCollection).getPersistenceCapableClass();
        if (candidatePCClass == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "jqlc.jqlc.checkcandidates.nullpc"));
        }
        if (!candidateClass.getName().equals(candidatePCClass.getName())) {
            throw new JDOQueryException(I18NHelper.getMessage(messages, "jqlc.jqlc.checkcandidates.mismatch", candidateClass.getName()));
        }
    }

    private JQLParser createStringParser(String text) {
        return JQLC.createStringParser(text, this.errorMsg);
    }

    public static JQLParser createStringParser(String text, ErrorMsg errorMsg) {
        StringReader in = new StringReader(text);
        JQLLexer lexer = new JQLLexer(in);
        lexer.init(errorMsg);
        TokenBuffer buffer = new TokenBuffer(lexer);
        JQLParser parser = new JQLParser(buffer);
        parser.init(errorMsg);
        parser.setASTFactory(JQLAST.Factory.getInstance());
        return parser;
    }
}

