/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.ejb;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentEventListener;
import com.sun.enterprise.deployment.backend.DeploymentEventManager;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.DeploymentHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.database.DatabaseConstants;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ResourceBundle;

public class DeploymentEventListenerImpl
implements DeploymentEventListener,
DatabaseConstants {
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", DeploymentEventListenerImpl.class.getClassLoader());
    private static Logger logger = LogHelperSQLStore.getLogger();

    DeploymentEventListenerImpl() {
    }

    public void notifyDeploymentEvent(DeploymentEvent event) {
        int type = event.getEventType();
        switch (type) {
            case 2: {
                this.processEvent(event.getEventInfo(), true);
                break;
            }
            case 3: {
                this.processEvent(event.getEventInfo(), false);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processEvent(DeploymentEventInfo info, boolean deploy) {
        debug = DeploymentEventListenerImpl.logger.isLoggable(500);
        cliCreateTables = null;
        cliDropAndCreateTables = null;
        cliDropTables = null;
        request = info.getDeploymentRequest();
        cliOverrides = request.getOptionalArguments();
        if (deploy) {
            cliDropAndCreateTables = cliOverrides.getProperty("CmpInfo.DROP_AND_CREATE_TABLES", "undefined");
            cliCreateTables = cliOverrides.getProperty("CmpInfo.CREATE_TABLES", "undefined");
            if (cliCreateTables.equals("undefined")) {
                cliCreateTables = cliDropAndCreateTables;
            }
        } else {
            cliDropTables = cliOverrides.getProperty("CmpInfo.DROP_TABLES", "undefined");
        }
        redeploy = deploy;
        try {
            if (request != null) {
                redeploy = request.isReDeploy();
            }
        }
        catch (IASDeploymentException e) {
            // empty catch block
        }
        application = info.getApplicationDescriptor();
        if (debug) {
            DeploymentEventListenerImpl.logger.fine("ejb.DeploymentEventListenerImpl.processingevent", deploy ? (redeploy ? "redeploy" : "deploy") : "undeploy", application.getRegistrationName());
        }
        status = request.getCurrentDeploymentStatus();
        status.setStageStatus(2);
        status.setStageStatusMessage("");
        bundleItr = application.getEjbBundleDescriptors().iterator();
        while (bundleItr.hasNext() != false) {
            block34: {
                block33: {
                    bundle = (EjbBundleDescriptor)bundleItr.next();
                    if (!bundle.containsCMPEntity() || !DeploymentHelper.isJavaToDatabase((cmpResource = bundle.getCMPResourceReference()).getSchemaGeneratorProperties())) continue;
                    createTables = deploy != false && (cliCreateTables.equals("true") != false || cmpResource.isCreateTablesAtDeploy() != false && cliCreateTables.equals("undefined") != false);
                    v0 = dropTables = redeploy != false && (cliDropAndCreateTables.equals("true") != false || cmpResource.isDropTablesAtUndeploy() != false && cliDropAndCreateTables.equals("undefined") != false) || deploy == false && (cliDropTables.equals("true") != false || cmpResource.isDropTablesAtUndeploy() != false && cliDropTables.equals("undefined") != false);
                    if (debug) {
                        DeploymentEventListenerImpl.logger.fine("ejb.DeploymentEventListenerImpl.createanddroptables", new Object[]{new Boolean(createTables), new Boolean(dropTables)});
                    }
                    if (!createTables && !dropTables) continue;
                    conn = null;
                    try {
                        try {
                            filePrefix = EJBHelper.getDDLNamePrefix(bundle);
                            createFile = null;
                            if (createTables) {
                                createFile = new File(info.getStubsDir(), filePrefix + "_createDDL.jdbc");
                                if (!createFile.exists()) {
                                    msg = I18NHelper.getMessage(DeploymentEventListenerImpl.messages, "ejb.DeploymentEventListenerImpl.cannotcreatetables", application.getRegistrationName(), createFile.getName());
                                    DeploymentEventListenerImpl.logger.warning(msg);
                                    DeploymentEventListenerImpl.warnUser(status, msg);
                                }
                                if (debug) {
                                    DeploymentEventListenerImpl.logger.fine("ejb.DeploymentEventListenerImpl.createfilename", createFile.getName());
                                }
                            }
                            dropFile = null;
                            if (dropTables) {
                                v1 = dir = deploy != false ? info.getOldStubsDir() : info.getStubsDir();
                                if (dir == null) {
                                    dir = info.getStubsDir();
                                }
                                if (!(dropFile = new File(dir, filePrefix + "_dropDDL.jdbc")).exists()) {
                                    if (deploy) {
                                        DeploymentEventListenerImpl.logger.warning(I18NHelper.getMessage(DeploymentEventListenerImpl.messages, "ejb.DeploymentEventListenerImpl.nodropfile", dropFile.getName()));
                                        dropTables = false;
                                    } else {
                                        DeploymentEventListenerImpl.logger.warning(I18NHelper.getMessage(DeploymentEventListenerImpl.messages, "ejb.DeploymentEventListenerImpl.cannotdroptables", application.getRegistrationName(), dropFile.getName()));
                                        var24_27 = null;
                                        if (conn == null) continue;
                                        break block33;
                                    }
                                }
                                if (debug) {
                                    DeploymentEventListenerImpl.logger.fine("ejb.DeploymentEventListenerImpl.dropfilename", dropFile.getName());
                                }
                            }
                            sql = null;
                            try {
                                conn = DeploymentHelper.getConnection(cmpResource.getJndiName());
                                sql = conn.createStatement();
                            }
                            catch (SQLException ex) {
                                DeploymentEventListenerImpl.cannotConnect(status, cmpResource, ex);
                                var24_27 = null;
                                if (conn == null) continue;
                                try {
                                    conn.close();
                                }
                                catch (SQLException ex) {}
                                continue;
                            }
                            catch (JDOFatalUserException ex) {
                                DeploymentEventListenerImpl.cannotConnect(status, cmpResource, ex);
                                var24_27 = null;
                                if (conn == null) continue;
                                try {}
                                catch (SQLException ex) {}
                                conn.close();
                                continue;
                            }
                            if (dropTables) {
                                this.executeDDLs(dropFile, sql, status);
                            }
                            if (!createTables) break block34;
                            this.executeDDLs(createFile, sql, status);
                            break block34;
                        }
                        catch (IOException e) {
                            msg = I18NHelper.getMessage(DeploymentEventListenerImpl.messages, "ejb.DeploymentEventListenerImpl.ioexception", application.getRegistrationName(), e.toString());
                            DeploymentEventListenerImpl.logger.warning(msg);
                            DeploymentEventListenerImpl.warnUser(status, msg);
                            var24_27 = null;
                            if (conn == null) continue;
                            try {}
                            catch (SQLException ex) {}
                            conn.close();
                            continue;
                        }
                    }
                    catch (Throwable var23_29) {
                        var24_27 = null;
                        if (conn == null) throw var23_29;
                        ** try [egrp 4[TRYBLOCK] [13 : 837->847)] { 
lbl114:
                        // 1 sources

                        conn.close();
                        throw var23_29;
lbl116:
                        // 1 sources

                        catch (SQLException ex) {
                            // empty catch block
                        }
                        throw var23_29;
                    }
                }
                try {}
                catch (SQLException ex) {}
                conn.close();
                continue;
            }
            var24_27 = null;
            if (conn == null) continue;
            try {}
            catch (SQLException ex) {}
            conn.close();
        }
    }

    private static void cannotConnect(DeploymentStatus status, ResourceReferenceDescriptor cmpResource, Throwable ex) {
        String msg = I18NHelper.getMessage(messages, "ejb.DeploymentEventListenerImpl.cannotConnect", cmpResource.getJndiName(), ex.toString());
        logger.warning(msg);
        DeploymentEventListenerImpl.warnUser(status, msg);
    }

    private static void warnUser(DeploymentStatus status, String msg) {
        status.setStageStatus(1);
        status.setStageStatusMessage(status.getStageStatusMessage() + "\n" + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDDLs(File f, Statement sql, DeploymentStatus status) throws IOException {
        StringBuffer warningBuf;
        block12: {
            BufferedReader reader = null;
            warningBuf = new StringBuffer();
            try {
                String s;
                reader = new BufferedReader(new FileReader(f));
                while ((s = reader.readLine()) != null) {
                    try {
                        if (logger.isLoggable(500)) {
                            logger.fine("ejb.DeploymentEventListenerImpl.executestatement", s);
                        }
                        sql.execute(s);
                    }
                    catch (SQLException ex) {
                        String msg = I18NHelper.getMessage(messages, "ejb.DeploymentEventListenerImpl.sqlexception", s, ex.toString());
                        logger.warning(msg);
                        warningBuf.append("\n\t").append(msg);
                    }
                }
                Object var10_9 = null;
                if (reader == null) break block12;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (warningBuf.length() > 0) {
                    String warning = I18NHelper.getMessage(messages, "ejb.DeploymentEventListenerImpl.tablewarning");
                    DeploymentEventListenerImpl.warnUser(status, warning + warningBuf.toString());
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (warningBuf.length() > 0) {
            String warning = I18NHelper.getMessage(messages, "ejb.DeploymentEventListenerImpl.tablewarning");
            DeploymentEventListenerImpl.warnUser(status, warning + warningBuf.toString());
        }
    }

    static {
        DeploymentEventManager.addListener((DeploymentEventListener)new DeploymentEventListenerImpl());
    }
}

