/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore;

import com.sun.jdo.api.persistence.support.JDODataStoreException;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.ActionDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.ConfigCache;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceConfig;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceStore;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.UpdateObjectDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.ValueFetcher;
import com.sun.jdo.spi.persistence.support.sqlstore.database.DBVendorType;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ConfigCacheImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.RetrieveDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.UpdateObjectDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.Concurrency;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.DBStatement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.SelectQueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.SelectStatement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.UpdateQueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.UpdateStatement;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;

public class SQLStoreManager
implements PersistenceStore {
    private ConfigCache configCache = new ConfigCacheImpl();
    private DBVendorType vendorType;
    private static Logger logger = LogHelperSQLStore.getLogger();
    private static Logger sqlLogger = LogHelperSQLStore.getSqlLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle(SQLStoreManager.class);
    private static int fetchSize = Integer.getInteger("com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager.fetchSize", -1);

    public PersistenceConfig getPersistenceConfig(Class classType) {
        if (logger.isLoggable(400)) {
            logger.finer("sqlstore.sqlstoremanager.getpersistenceconfig", classType.getName());
        }
        return this.configCache.getPersistenceConfig(classType);
    }

    public ConfigCache getConfigCache() {
        return this.configCache;
    }

    public void execute(PersistenceManager pm, Collection actions) {
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            ActionDesc action = (ActionDesc)iter.next();
            if (action instanceof UpdateObjectDescImpl) {
                UpdateObjectDescImpl request = (UpdateObjectDescImpl)action;
                UpdateQueryPlan plan = new UpdateQueryPlan(request, this);
                plan.build();
                int size = plan.statements.size();
                for (int i = 0; i < size; ++i) {
                    UpdateStatement s = (UpdateStatement)plan.statements.get(i);
                    if (s == null) continue;
                    this.executeUpdate(pm, s, request);
                }
                continue;
            }
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", action.getClass().getName(), "UpdateObjectDescImpl"));
        }
    }

    private void rollbackXact(Transaction tran) {
        try {
            tran.setRollbackOnly();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdate(PersistenceManager pm, UpdateStatement updateStatement, UpdateObjectDescImpl updateDesc) {
        String sqlText;
        int affectedRows = 0;
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("sqlstore.sqlstoremanager.executeupdate");
        }
        if ((sqlText = updateStatement.getText()).length() > 0) {
            DBStatement s;
            Connection conn;
            Transaction tran;
            block9: {
                if (sqlLogger.isLoggable()) {
                    sqlLogger.fine(updateStatement.getFormattedSQLText());
                }
                tran = (Transaction)pm.currentTransaction();
                conn = tran.getConnection();
                s = null;
                boolean preparationSuccessful = false;
                try {
                    s = new DBStatement(conn, sqlText, tran.getUpdateTimeout());
                    updateStatement.bindInputValues(s);
                    preparationSuccessful = true;
                    affectedRows = s.executeUpdate();
                    if (affectedRows >= updateStatement.minAffectedRows) break block9;
                    updateDesc.setVerificationFailed();
                    this.rollbackXact(tran);
                    SQLStoreManager.throwJDOConcurrentAccessException(sqlText);
                }
                catch (SQLException e) {
                    try {
                        if (preparationSuccessful) {
                            updateDesc.setVerificationFailed();
                        }
                        this.rollbackXact(tran);
                        SQLStoreManager.throwJDOSqlException(e, updateStatement.getFormattedSQLText());
                    }
                    catch (Throwable throwable) {
                        SQLStoreManager.close(s);
                        SQLStoreManager.closeConnection(tran, conn);
                        throw throwable;
                    }
                    SQLStoreManager.close(s);
                    SQLStoreManager.closeConnection(tran, conn);
                }
            }
            SQLStoreManager.close(s);
            SQLStoreManager.closeConnection(tran, conn);
        }
        if (debug) {
            logger.fine("sqlstore.sqlstoremanager.executeupdate.exit", new Integer(affectedRows));
        }
    }

    public Class getClassByOidClass(Class oidType) {
        return this.configCache.getClassByOidClass(oidType);
    }

    public StateManager getStateManager(Class classType) {
        ClassDesc c = (ClassDesc)this.getPersistenceConfig(classType);
        if (c != null) {
            return c.newStateManagerInstance(this);
        }
        return null;
    }

    public RetrieveDesc getRetrieveDesc(Class classType) {
        return new RetrieveDescImpl(classType, (ClassDesc)this.getPersistenceConfig(classType));
    }

    public RetrieveDesc getRetrieveDesc(String fieldName, Class classType) {
        FieldDesc f;
        ClassDesc c = (ClassDesc)this.getPersistenceConfig(classType);
        if (c != null && (f = c.getField(fieldName)) instanceof ForeignFieldDesc) {
            ForeignFieldDesc ff = (ForeignFieldDesc)f;
            return this.getRetrieveDesc(ff.foreignConfig.getPersistenceCapableClass());
        }
        return null;
    }

    public UpdateObjectDesc getUpdateObjectDesc(Class classType) {
        return new UpdateObjectDescImpl(classType);
    }

    public SQLStoreManager(DatabaseMetaData databaseMetaData, String identifier) {
        this.setVendorType(databaseMetaData, identifier);
    }

    private void setVendorType(DatabaseMetaData databaseMetaData, String identifier) {
        try {
            this.vendorType = new DBVendorType(databaseMetaData, identifier);
            if (logger.isLoggable()) {
                logger.fine("sqlstore.sqlstoremanager.vendortype", this.vendorType.getName());
            }
        }
        catch (Exception e) {
            if (e instanceof JDOException) {
                throw (JDOException)e;
            }
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.getvendortypefailed"), e);
        }
    }

    public DBVendorType getVendorType() {
        return this.vendorType;
    }

    public Object retrieve(PersistenceManager pm, RetrieveDesc action, ValueFetcher parameters) {
        if (action == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.nullparam", "action"));
        }
        if (!(action instanceof RetrieveDescImpl)) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", action.getClass().getName(), "RetrieveDescImpl"));
        }
        RetrieveDescImpl retrieveAction = (RetrieveDescImpl)action;
        ClassDesc config = retrieveAction.getConfig();
        Concurrency concurrency = config.getConcurrency(pm.isOptimisticTransaction());
        SelectQueryPlan plan = retrieveAction.buildQueryPlan(this, concurrency);
        ArrayList statements = plan.getStatements();
        Object result = null;
        SelectStatement s = (SelectStatement)statements.get(0);
        result = this.executeQuery(pm, s, concurrency, parameters);
        if ((plan.options & 0x1F8) == 0 && (plan.options & 2) > 0 && (plan.options & 4) > 0 && !this.vendorType.isDistinctSupportedWithUpdateLock()) {
            HashSet hash = new HashSet();
            Iterator iter = ((Collection)result).iterator();
            while (iter.hasNext()) {
                Object temp = iter.next();
                if (!hash.contains(temp)) {
                    hash.add(temp);
                    continue;
                }
                iter.remove();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeQuery(PersistenceManager pm, SelectStatement statement, Concurrency concurrency, ValueFetcher parameters) {
        String sqlText;
        Object result = null;
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("sqlstore.sqlstoremanager.executeQuery");
        }
        if ((sqlText = statement.getText()).length() > 0) {
            if (sqlLogger.isLoggable()) {
                sqlLogger.fine(statement.getFormattedSQLText(parameters));
            }
            Transaction tran = null;
            if (concurrency != null) {
                tran = concurrency.suspend();
            }
            if (tran == null) {
                tran = (Transaction)pm.currentTransaction();
            }
            ResultSet resultData = null;
            DBStatement s = null;
            Connection conn = tran.getConnection();
            try {
                s = new DBStatement(conn, sqlText, tran.getQueryTimeout());
                statement.bindInputValues(s, parameters);
                if (fetchSize > -1) {
                    s.getPreparedStatement().setFetchSize(fetchSize);
                }
                if (statement.isColumnTypeDefinitionNeeded()) {
                    this.vendorType.getSpecialDBOperation().defineColumnTypeForResult(s.getPreparedStatement(), statement.getColumnRefs());
                }
                resultData = s.executeQuery();
                if (concurrency != null) {
                    concurrency.resume(tran);
                }
                SelectQueryPlan plan = (SelectQueryPlan)statement.getQueryPlan();
                result = plan.getResult(pm, resultData);
            }
            catch (SQLException e) {
                try {
                    SQLStoreManager.throwJDOSqlException(e, statement.getFormattedSQLText(parameters));
                }
                catch (Throwable throwable) {
                    SQLStoreManager.close(resultData);
                    SQLStoreManager.close(s);
                    SQLStoreManager.closeConnection(tran, conn);
                    throw throwable;
                }
                SQLStoreManager.close(resultData);
                SQLStoreManager.close(s);
                SQLStoreManager.closeConnection(tran, conn);
            }
            SQLStoreManager.close(resultData);
            SQLStoreManager.close(s);
            SQLStoreManager.closeConnection(tran, conn);
        }
        if (debug) {
            logger.fine("sqlstore.sqlstoremanager.executeQuery.exit");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeBatch(PersistenceManager pm, UpdateObjectDesc request, boolean forceFlush) {
        Connection conn;
        Transaction tran;
        block4: {
            boolean cleanup = true;
            UpdateObjectDescImpl objectRequest = null;
            if (!(request instanceof UpdateObjectDescImpl)) throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", request.getClass().getName(), "UpdateObjectDescImpl"));
            objectRequest = (UpdateObjectDescImpl)request;
            ClassDesc config = objectRequest.getConfig();
            UpdateQueryPlan plan = config.getUpdateQueryPlan(objectRequest, this);
            tran = (Transaction)pm.currentTransaction();
            conn = tran.getConnection();
            boolean doFlush = forceFlush || plan.checkBatchThreshold(tran);
            try {
                int size = plan.statements.size();
                for (int i = 0; i < size; ++i) {
                    UpdateStatement s = (UpdateStatement)plan.statements.get(i);
                    this.executeUpdateBatch(tran, conn, s, objectRequest, doFlush);
                }
                cleanup = forceFlush;
                Object var15_14 = null;
                if (!cleanup) break block4;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                if (cleanup) {
                    SQLStoreManager.closeDBStatements(plan, tran);
                }
                SQLStoreManager.closeConnection(tran, conn);
                throw throwable;
            }
            SQLStoreManager.closeDBStatements(plan, tran);
        }
        SQLStoreManager.closeConnection(tran, conn);
    }

    private void executeUpdateBatch(Transaction tran, Connection conn, UpdateStatement updateStatement, UpdateObjectDescImpl updateDesc, boolean doFlush) {
        String sqlText;
        int[] affectedRows = null;
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("sqlstore.sqlstoremanager.executeupdatebatch");
        }
        if ((sqlText = updateStatement.getText()).length() > 0) {
            if (sqlLogger.isLoggable()) {
                String formattedText = updateStatement.getFormattedSQLText(updateDesc);
                if (doFlush) {
                    sqlLogger.fine("sqlstore.sqlstoremanager.executeupdatebatch.flushbatch", formattedText);
                } else {
                    sqlLogger.fine("sqlstore.sqlstoremanager.executeupdatebatch.addbatch", formattedText);
                }
            }
            DBStatement s = null;
            try {
                s = updateStatement.getDBStatement(tran, conn);
                updateStatement.bindInputColumns(s, updateDesc);
                s.addBatch();
                if (doFlush) {
                    affectedRows = s.executeBatch();
                    for (int i = 0; i < affectedRows.length; ++i) {
                        if (affectedRows[i] >= updateStatement.minAffectedRows || affectedRows[i] == -2) continue;
                        this.rollbackXact(tran);
                        SQLStoreManager.throwJDOConcurrentAccessException(sqlText);
                    }
                }
            }
            catch (SQLException e) {
                this.rollbackXact(tran);
                SQLStoreManager.throwJDOSqlException(e, sqlText);
            }
        }
        if (debug) {
            if (doFlush) {
                logger.fine("sqlstore.sqlstoremanager.executeupdatebatch.exit.flush", '[' + StringHelper.intArrayToSeparatedList(affectedRows, ",") + ']');
            } else {
                logger.fine("sqlstore.sqlstoremanager.executeupdatebatch.exit");
            }
        }
    }

    private static void throwJDOSqlException(SQLException e, String sqlText) {
        String exceptionMessage = I18NHelper.getMessage(messages, "core.persistencestore.jdbcerror", sqlText);
        throw new JDODataStoreException(exceptionMessage, e);
    }

    private static void throwJDOConcurrentAccessException(String sqlText) {
        String operation = sqlText.substring(0, sqlText.indexOf(32));
        throw new JDODataStoreException(I18NHelper.getMessage(messages, "core.store.concurrentaccess", operation));
    }

    private static void close(ResultSet r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (SQLException ex) {
                logger.finest(I18NHelper.getMessage(messages, "sqlstore.sqlstoremanager.errorcloseresultset", ex.getLocalizedMessage()));
            }
        }
    }

    private static void close(DBStatement s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (SQLException ex) {
                logger.finest(I18NHelper.getMessage(messages, "sqlstore.sqlstoremanager.errorclosestatement", ex.getLocalizedMessage()));
            }
        }
    }

    private static void closeConnection(Transaction t, Connection c) {
        if (t != null && c != null) {
            t.releaseConnection();
        }
    }

    private static void closeDBStatements(UpdateQueryPlan plan, Transaction tran) {
        if (plan != null && tran != null) {
            Iterator i = plan.getStatements().iterator();
            while (i.hasNext()) {
                UpdateStatement updateStmt = (UpdateStatement)i.next();
                DBStatement s = updateStmt.removeDBStatement(tran);
                SQLStoreManager.close(s);
            }
        }
    }
}

